/**
 * Copyright hacker_u_yjm2r7 ( http://wonderfl.net/user/hacker_u_yjm2r7 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pQOC
 */

package {
	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.events.Event;
	import flash.system.System;
	import flash.filters.DropShadowFilter;


	public class MyTextField extends Sprite {
		public var textLoader:URLLoader; // 外部テキストファイルを読込んで表示するためのクラス
		public function MyTextField() {

			//読み込むURLを設定する
			var urlReq:URLRequest = new URLRequest();
			urlReq.url = "http://oshige.com/flash/wfl/surfride.txt";

			//utfコードのテキストを読み込む場合はfalse（初期値）
			System.useCodePage = false;

			//URLLoaderクラスを使ってテキストデータを読み込みます。
			textLoader = new URLLoader();
			textLoader.addEventListener(Event.COMPLETE, completeHandler);
			//読み込み開始。
			textLoader.load(urlReq);
		}


		//読み込みが完了したら実行される
		public function completeHandler(event:Event):void {
			var fld:TextField = creatTextField();
			//読み込んだテキストデータをHTMLとしてフィールドへ入れます。
			fld.htmlText = textLoader.data;
		}


		//テキストフィールドを作ります。
		public function creatTextField():TextField 
        {

			//テキストの書式
			var tf:TextFormat = new TextFormat();
			tf.font = "_typewriter";
			tf.size = 16;
			tf.color = 0x333333;

			//テキストフィールドの作成
			var fld:TextField = new TextField();
			fld.autoSize = TextFieldAutoSize.LEFT;
			fld.wordWrap = true;
			fld.width = 340;
			fld.x = 50;
			fld.y = 20;
			fld.background = true;
			fld.backgroundColor = 0xDDDDDD;
			fld.defaultTextFormat = tf;

			//<br>タグで改行されるようにします。
			fld.multiline = true;

			//ドロップシャドウフィルタを作って設定します。
			var dsf:DropShadowFilter = new DropShadowFilter();
			dsf.alpha = 0.6;
			fld.filters = [dsf];

			addChild(fld);
			return fld;
		}
	}
}