/**
 * Copyright geko ( http://wonderfl.net/user/geko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pPxh
 */

// 読み込みテスト
// forked from Event's Simple MediaRSS Viewer
package {
    import flash.text.TextFormat;
    import flash.display.*;
    import flash.events.*;
    import flash.text.TextField;
    import com.bit101.components.PushButton;
    import caurina.transitions.Tweener;

    public class MediaRSSReader extends Sprite {
        private var mediaRSS:MediaRSS = new MediaRSS();
        private var tag:TextField = new TextField();
        private var message:TextField = new TextField();
        private var showBt:Shape = new Shape();
        private var showBtField:Sprite = new Sprite();
        private var xmlMask:Sprite = new Sprite();
        private var xmlSprite:Sprite = new Sprite();
        private var xmlText:TextField = new TextField();
        private var lineNumText:TextField = new TextField();
        private var xmlTextField:Sprite = new Sprite();
        private var container:Sprite = new Sprite();
        private var rollOver:Boolean = false;

        public function MediaRSSReader() {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            tag.width = 100;
            tag.height = 20;
            tag.x = (stage.stageWidth-tag.width)/2-70;
            tag.y = 420;
            tag.border = tag.background = true;
            tag.textColor = 0x555555;
            tag.borderColor = 0x888888;
            tag.type = "input";
            tag.text = "portlate";
            message.width = 250;
            message.height = 20;
            message.x = tag.x;
            message.y = 400;
            message.mouseEnabled = false;
            message.textColor = 0x555555;
            addChild(tag);
            addChild(message);
            
            var searchBt:PushButton = new PushButton(this, tag.x+tag.width+5,tag.y,"search",click);
            searchBt.setSize(60,20);
            
            container.x = container.y = 15;
            addChild(container);
            
            //RSSの表示
            xmlSprite.x = stage.stageWidth-8;
            xmlTextField.graphics.lineStyle(1, 0x666666);
            xmlTextField.graphics.beginFill(0xFFFFFF, 0.8);
            xmlTextField.graphics.drawRect(8, 1, stage.stageWidth-9, stage.stageHeight-2);
            xmlTextField.graphics.endFill();
            xmlTextField.graphics.lineStyle(1, 0xCCCCCC);
            xmlTextField.graphics.moveTo(37, 5);
            xmlTextField.graphics.lineTo(37, stage.stageHeight-10);
            xmlTextField.graphics.lineStyle(1, 0xAAAAAA);
            xmlTextField.graphics.beginFill(0xFFFFFF, 0);
            xmlTextField.graphics.drawRect(13, 5, stage.stageWidth-20, stage.stageHeight-10);
            xmlTextField.graphics.endFill();
            xmlText.x = 38;
            xmlText.y = 5;
            xmlText.width = stage.stageWidth-45;
            xmlText.height = stage.stageHeight-10;
            xmlText.textColor = 0x666666;
            lineNumText.defaultTextFormat = new TextFormat(null, 11, 0x888888, null, null, null, null, null, "right",null,null,null,1);
            lineNumText.x = 13;
            lineNumText.y = 7;
            lineNumText.width = 25;
            lineNumText.height = stage.stageHeight-12;
            lineNumText.mouseEnabled = false;
            showBt.graphics.beginFill(0xFFFFFF, 0.8);
            showBt.graphics.moveTo(2,-5);
            showBt.graphics.lineTo(-2,0);
            showBt.graphics.lineTo(2,5);
            showBt.graphics.endFill();
            showBtField.alpha = 0.5;
            showBtField.graphics.beginFill(0x000000, 0.6);
            showBtField.graphics.drawRect(0, 0, 8, stage.stageHeight);
            showBtField.graphics.endFill();
            showBt.x = 4;
            showBt.y = showBtField.height/2;
            xmlSprite.addChild(xmlTextField);
            xmlSprite.addChild(xmlText);
            xmlSprite.addChild(lineNumText);
            xmlSprite.addChild(showBtField);
            xmlSprite.addChild(showBt);
            stage.addChild(xmlSprite);
            
            xmlText.addEventListener(MouseEvent.ROLL_OVER, function ():void{
                rollOver = true;
            });
            xmlText.addEventListener(MouseEvent.ROLL_OUT, function ():void{
                rollOver = false;
            });
            stage.addEventListener(Event.ENTER_FRAME, function scroll(event:Event):void{
                if(!rollOver || xmlSprite.x > 0) return;
                xmlText.scrollH = Math.min(Math.max(xmlText.scrollH+(mouseX-stage.stageWidth/2)/5, 1), xmlText.maxScrollH);
                xmlText.scrollV = lineNumText.scrollV = Math.min(Math.max(xmlText.scrollV+(mouseY-stage.stageHeight/2)/20, 1), xmlText.maxScrollV);
                
            });
            showBtField.addEventListener(MouseEvent.ROLL_OVER, function ():void{
                Tweener.addTween(showBtField, {alpha:1,time:0.8});
            });
            showBtField.addEventListener(MouseEvent.ROLL_OUT, function ():void{
                Tweener.addTween(showBtField, {alpha:0.5,time:0.8});
            });
            showBtField.addEventListener(MouseEvent.CLICK, show);
            
            mediaRSS.load(tag.text);
            message.text = "now loading...";
            tag.mouseEnabled = false;
            tag.textColor = 0xAAAAAA;
            mediaRSS.addEventListener(Event.COMPLETE, onImageLoaded);
        }
        private function click(event:MouseEvent):void{
            while(container.numChildren) {
                var target:Bitmap = container.getChildAt(0) as Bitmap;
                container.removeChildAt(0);
                target.bitmapData.dispose();
                target = null;
            }
            message.text = "now loading...";
            tag.mouseEnabled = false;
            tag.textColor = 0xAAAAAA;
            mediaRSS.load(tag.text);
        }
        
        private function onImageLoaded(event:Event):void{
            xmlText.text = mediaRSS.rss.toXMLString();
            setLineNumText();
            xmlText.scrollH = lineNumText.scrollH = 1;
            xmlText.scrollV = lineNumText.scrollV = 1;
            tag.mouseEnabled = true;
            tag.textColor = 0x555555;
            message.text = tag.text+" : "+mediaRSS.images.length+"枚見つけたよ。";
            for (var i:int = 0; i < mediaRSS.images.length; i++){
                var bmp:Bitmap = new Bitmap(mediaRSS.images[i]);
                bmp.x = (i % 5) * 85;
                bmp.y = Math.floor(i / 5) * 85;
                container.addChild(bmp);
            }
        }
        
        private function show(event:MouseEvent):void{
            _show = !_show;
            Tweener.addTween(xmlSprite, {x:_show ? 0 : stage.stageWidth-8,time:1});
            Tweener.addTween(showBt, {rotation:_show ? 180 : 0, time:1});
            //Tweener.addTween(xmlText, {scrollV:_show ? xmlText.maxScrollV : 0, time:20})
        }
        private function setLineNumText():void{
            lineNumText.text = String(1+"\n");
            for(var i:int = 2; lineNumText.numLines < xmlText.numLines; i++){
                lineNumText.appendText(String(i)+"\n");
            }

        }

        private var _show:Boolean = false;
    }
}

import flash.display.*;
import flash.events.*;
import flash.net.*;
import flash.system.*;

//MediaRSS
class MediaRSS extends EventDispatcher{
    private var feed:String = "http://api.flickr.com/services/feeds/photos_public.gne?format=rss_200&tags=";
    private var media:Namespace = new Namespace("http://search.yahoo.com/mrss/");
    
    public function MediaRSS(){
        init();
    }
    private function init():void{
    }
    private function mediaRSSReader():void{
        var urlLoader:URLLoader = new URLLoader();
        urlLoader.addEventListener(Event.COMPLETE, function load(event:Event):void {
            urlLoader.removeEventListener(Event.COMPLETE, load);
            rss = XML(urlLoader.data); 
            //これは多分サムネイルのURLを呼び出している
            onImageLoaded(rss..media::thumbnail.@url.toXMLString().split('\n'));
        });
        urlLoader.load(new URLRequest(feed+tag));
    }
    private function onImageLoaded(rss:Array):void{
        //タグが見つからなかった場合
        if(rss[0] == ""){
            rss.pop();
            dispatchEvent(new Event(Event.COMPLETE));
        }

        for each(var url:String in rss){
            var loader:Loader = new Loader();
            loader.load(new URLRequest(url), new LoaderContext(true));
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, function complete(event:Event):void{
                loader.removeEventListener(Event.COMPLETE, complete);
                var bmd:BitmapData = new BitmapData(event.target.width, event.target.height, false);
                bmd.draw(event.target.content);
                images.push(bmd);
                if(url == rss[rss.length-1]) dispatchEvent(event);
            });
        }
    }

    public function load(tag:String = ""):void{
        if(tag) this.tag = tag;
        images = new Vector.<BitmapData>();
        mediaRSSReader();
    }

    //BitmapData格納変数
    public var images:Vector.<BitmapData>;
    //検索タグ
    public var tag:String = "";
    public var rss:XML;
}