/**
 * Copyright baudon.thomas ( http://wonderfl.net/user/baudon.thomas )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pPvu
 */

package {
    import flash.display.Shape;
    import flash.events.MouseEvent;
    import flash.display.Sprite;
   
    public class FlashTest extends Sprite {
        
        private var Ax : Number;
        private var Ay : Number;
        
        private var Bx : Number;      
        private var By : Number;  
        
        private var Cx : Number;
        private var Cy : Number;
        
        private var Dx : Number;
        private var Dy : Number;
        
        private var canvas : Shape;
        
        public function FlashTest() {
            // write as3 code here..
            
            stage.addEventListener(flash.events.MouseEvent.MOUSE_DOWN, onMouseDown);
            canvas = new Shape();
            addChild(canvas);
        }
        
        private function onMouseDown(e:MouseEvent):void{
            generate();
        }
        
        private function generate() : void {
            Ax = Math.random() * 100 + 100;
            Ay = Math.random() * 100 + 100;
            
            Bx = Math.random() * 100 + 100;
            By = Math.random() * 100 + 100;
            
            Cx = Math.random() * 100 + 100;
            Cy = Math.random() * 100 + 100;
            
            canvas.graphics.clear();
            
            canvas.graphics.beginFill(0xff0000);
            canvas.graphics.drawCircle(Ax, Ay, 3);
            canvas.graphics.endFill();
            
            canvas.graphics.beginFill(0x00cc00);
            canvas.graphics.drawCircle(Bx, By, 3);
            canvas.graphics.endFill();
            
            canvas.graphics.beginFill(0x0000cc);
            canvas.graphics.drawCircle(Cx, Cy, 3);
            canvas.graphics.endFill();
            
            canvas.graphics.lineStyle(1,0x000000,1);
            canvas.graphics.moveTo(Ax, Ay);
            canvas.graphics.lineTo(Bx, By);
            canvas.graphics.lineTo(Cx, Cy);
            
            computeD();
            
            canvas.graphics.beginFill(0xFFFF00);
            canvas.graphics.drawCircle(Dx, Dy, 3);
            canvas.graphics.endFill();
            
            canvas.graphics.moveTo(Bx, By);
            canvas.graphics.lineTo(Dx, Dy);
        }
        
        private function computeD() : void {
            Dx = 0;
            Dy = 0;
            
            var ABx : Number = Ax - Bx;
            var ABy : Number = Ay - By;
            var NAB : Number = Math.sqrt(ABx * ABx + ABy * ABy);
            
            var Nx : Number = ABx / NAB;
            var Ny : Number = ABy / NAB;
            
            var CBx : Number = Bx - Cx;
            var CBy : Number = By - Cy;
            
            var scal : Number = CBx * Nx + CBy * Ny;
            
            var CPx : Number = CBx - 2 * scal * Nx;
            var CPy : Number = CBy - 2 * scal * Ny;
            
            Dx = Bx + CPx;
            Dy = By + CPy;
        }



    }
}