/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pOjZ
 */

// forked from siouxcitizen's Winter03 前回ハリボテツリーにBlurFilter効果ピクセルを追加してみました
//ハリボテツリーにTwitter投稿機能＆アマゾンアフィリエイトへのリンクボタンを追加しました
//
//3DPlaneオブジェクトで作ったクリスマスツリーをクリックすると色が緑→赤→青→黄→白→緑と変化します。
//3DPlaneで作ったフィールド部分もクリックすると白地面→白地面＋白い木→白地面と変化します。　
//いちおー白は積もった雪のイメージです。。。
//「リセット」ボタンで上記状態が初期状態(ツリーは緑、フィールドは白地面)にもどります。
//
//Wボタンでカメラ視点上移動
//Sボタンでカメラ視点下移動
//Aボタンでカメラ視点が操作矢印を中心に左周り
//Dボタンでカメラ視点が操作矢印を中心に右周り
//Fボタンでカメラ距離変更
//
//「降雪」ボタンで降り注ぐ雪にみたてたパーティクルが落ちてきます
//「雪月下」ボタンでクリスマスツリーがライトアップされます
//「ライトアップ」ボタンでクリスマスツリーの周りにBlurFiter効果のピクセルによるライトアップを行います
//「Tweet」ボタン押下でこのコードのURLをTwitterへ投稿
//「祝木リスト」ボタン押下でアマゾンで「クリスマスツリー」で検索を行います(とりあえず自分のアフィリエイトID使ってます)。
//↑実際に検索画面→商品と遷移していった先までアフィリエイトIDが運ばれていくのかよくわかりませんが。。。
//　
//Twitter投稿機能は前に作った以下コードから流用しました
//RSS経由？でTwitterデータを検索・取得処理の練習
//http://wonderfl.net/c/AoGJ
package {
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;
    import flash.net.URLRequest;
    import flash.net.navigateToURL;
    import flash.utils.escapeMultiByte;
    import flash.filters.GlowFilter;
    import flash.filters.BlurFilter;

    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.objects.primitives.Arrow;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.objects.primitives.Cylinder;
    import org.papervision3d.objects.primitives.Cone;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.events.InteractiveScene3DEvent;

    import org.papervision3d.materials.special.Letter3DMaterial;
    import org.papervision3d.typography.Text3D;
    import org.papervision3d.typography.fonts.HelveticaBold;

    import org.papervision3d.materials.special.ParticleMaterial;
    import org.papervision3d.objects.special.ParticleField;
    import org.papervision3d.core.geom.renderables.Particle;

    import org.papervision3d.core.effects.BitmapLayerEffect;
    import org.papervision3d.core.effects.utils.BitmapClearMode;
    import org.papervision3d.core.geom.Pixels;
    import org.papervision3d.core.geom.renderables.Pixel3D;
    import org.papervision3d.view.layer.BitmapEffectLayer;
    [SWF(width="500", height="500", backgroundColor="#0055FF")]
    public class Winter extends Sprite {
        private var goLandScrnBtn : SimpleButton;//ランド画面への遷移ボタン 

        private var resetBtn : SimpleButton;//リセットボタン
        private var snowFallBtn : SimpleButton;//「降雪」ボタン
        private var snowFallState : Boolean = false; //「降雪」ボタン状態管理用
        private var snowNightBtn : SimpleButton;//「雪月下」ボタン
        private var snowNightState : Boolean = false; //「雪月下」ボタン状態管理用
        private var lightUpBtn : SimpleButton;//「ライトアップ」ボタン
        private var lightUpState : Boolean = false; //「ライトアップ」ボタン状態管理用
        private var tweetBtn : SimpleButton;//「ライトアップ」ボタン
        private var affiliateBtn : SimpleButton;//「ライトアップ」ボタン
        private var goTitleScrnBtn : SimpleButton;//タイトル画面への遷移ボタン
        private var forwardBtn : SimpleButton;//前進ボタン
        private var leftRotBtn : SimpleButton;//左回転ボタン
        private var rightRotBtn : SimpleButton;//右回転ボタン
        private var backwardBtn : SimpleButton;//後退ボタン
        private var bDashBtn : SimpleButton;//Bダッシュボタン
        private var forwardState : Boolean = false; //操作矢印「前進」制御用
        private var backwardState : Boolean = false; //操作矢印「後退」制御用
        private var bDashState : Boolean = false; //操作矢印「Bダッシュ」制御用
        private var leftRotState : Boolean = false; //操作矢印「左回転」制御用
        private var rightRotState : Boolean = false; //操作矢印「右回転」制御用

        private var txtField:Object=new Object(); //テキストフィールド用
        private var txtFormat:Object=new Object();//テキストフォーマット用

        private var screenId : int = 0;  //0:クエスト画面 1:ランド画面
        private const TITLE_SCREEN_ID : int = 0;  //クエスト画面ID
        private const LAND_SCREEN_ID : int = 1;  //ランド画面ID

        private const TWEET_COMMENT : String = "メリークリスマス！　私からのクリスマスツリーをどうぞ！！！ ";
        private const CHRISTMAS_TREE_URL : String = "http://wonderfl.net/c/pOjZ/";  //クリスマスツリーのURL
        private const HASH_TAG_GROUP : String = "#wonderfl";  //Twitterハッシュタググループ
        //アフィリエイト用URL　
        //↓アマゾンの自分のアフィリエイトID使って「クリスマスツリー」で検索を行うURLです
        //↓いちおーアフィリエイトID渡してますが、実際に機能するのかは確認してません、というかできず。。。
        private const AFFILIATE_URL : String = "http://www.amazon.co.jp/gp/search?ie=UTF8&keywords=%E3%82%AF%E3%83%AA%E3%82%B9%E3%83%9E%E3%82%B9%E3%83%84%E3%83%AA%E3%83%BC&tag=myinteresting-22&index=aps&linkCode=ur2&camp=247&creative=1211";
        
        //3D表示用
        private var container : Sprite;
        private var viewport : Viewport3D;
        private var scene : Scene3D;
        private var camera : Camera3D;
        private var material : ColorMaterial;
        private var planeObj : Plane; 
        private var arrow : Arrow //操作用オブジェクト
        private var crystalBoxCube : Cube //透明キューブ　飾り用クリスタル役
        private var moonSphere : Sphere //月スフェア
        private var starPlaneOne : Plane //クリスマスツリーの星用Planeその1
        private var starPlaneTwo : Plane //クリスマスツリーの星用Planeその2
        private var renderer : BasicRenderEngine;
        private var materialList : MaterialsList = new MaterialsList();

        private var cameraPitch: int = 90; //カメラのX軸回転の値　
        private var cameraYaw : int = 270; //カメラのY軸回転の値　
        private var cameraDistStat: int = 1; //カメラ設置場所の距離種類　0～2

        private var title3DText : Text3D //タイトル3D文字
        private var letterformat : Letter3DMaterial; //タイトル3D文字フォーマット
        private var tempPlaneName : String;
        private var Objs : Object = new Object(); //3Dオブジェクト保持用

        private var particleMat : ParticleMaterial; //生成するパーティクルのマテリアル
        private var particleField : ParticleField; //生成するパーティクルのフィールド
        private var pFieldHeight : int;
        private var numParticles : int;
        private var fieldSize : int;
        private var theta : Number = 0;
        private var windOffset : Array;
        private var filterList : Array;
        private var pixels:Pixels;
        public function Winter() {


            //情報表示用テキストフィールドを初期化
            txtFieldInit();

            //3D空間を初期化
            init3DSpace();

            //タイトル画面を初期化
            initTitleScrnBtn();
            //ランド画面を初期化
            initLandScrnBtn();
        }

        //テキストフィールドの初期化処理
        private function txtFieldInit():void{
            //テキストフィールド(ラベル)の生成
            txtField["titleScrnInfo"]=Util.makeTxtField(10,10,10,10);//タイトル画面表示用のテキストを設定
            txtField["landScrnInfo"]=Util.makeTxtField(10,10,300,40);//ランド画面表示用のテキストを設定
            //テキストフォーマットの生成
            txtFormat["titleScrnInfo"]=Util.makeTextFormat(15,0x000000);
            txtFormat["landScrnInfo"]=Util.makeTextFormat(15,0x000000);
        }
        //テキストフィールドの編集
        private function editLabel(key:String,text:String):void {
            txtField[key].text=text;
            txtField[key].setTextFormat(txtFormat[key]);        
        }

        //タイトル画面情報テキストを設定
        public function addTitleScrnTxt():void {
            addChild(txtField["titleScrnInfo"]); //タイトル画面のテキストを表示(今回は使用せず)
            editLabel("titleScrnInfo", "");
        }
        //タイトル画面情報テキストを設定解除
        public function removeTitleScrnTxt():void {
            editLabel("titleScrnInfo", "");
            removeChild(txtField["titleScrnInfo"]); //タイトル画面のテキストを非表示(今回は使用せず)
        }
        //ランド画面情報テキストを設定
        private function addLandScrnTxt():void {
            addChild(txtField["landScrnInfo"]);
            var landScrnInfoTxt : String = "床・ツリーをクリックで状態変化" + "\n"
                                         + "A,W,S,D,Fボタンで視点変更" + "\n";
            editLabel("landScrnInfo",landScrnInfoTxt);
        }
        //ランド画面情報テキストを設定解除
        private function removeLandScrnTxt():void {
            editLabel("landScrnInfo", "");
            removeChild(txtField["landScrnInfo"]);
        }
//■■■タイトル画面ボタン初期化スタート■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
        //タイトル画面ボタンを初期化する
        public function initTitleScrnBtn():void {
            goLandScrnBtn = new CustomButton("ランド画面");
            goLandScrnBtn.x = 400;
            goLandScrnBtn.y = 280;
            goLandScrnBtn.addEventListener(MouseEvent.MOUSE_DOWN,goLandScrnBtnDown);
            addChild(goLandScrnBtn);
        }
        //タイトル画面ボタンを非表示にする
        public function hideTitleScrnBtn():void {
            goLandScrnBtn.visible = false;
        }
        //タイトル画面ボタンを表示する
        public function dispTitleScrnBtn():void {
            goLandScrnBtn.visible = true;
        }
//■■■タイトル画面ボタン初期化エンド■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
//■■■ランド画面ボタン初期化スタート■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
        //ランド画面ボタンを初期化する
        public function initLandScrnBtn():void {
            //「リセット」ボタン設定
            resetBtn = new CustomButton("リセット");
            resetBtn.x = 400;
            resetBtn.y = 0;
            resetBtn.addEventListener(MouseEvent.MOUSE_DOWN,onResetBtnDown);
            addChild(resetBtn);
            //「桜散」ボタン設定
            snowFallBtn = new CustomButton("降雪");
            snowFallBtn.x = 400;
            snowFallBtn.y = 30;
            snowFallBtn.addEventListener(MouseEvent.MOUSE_DOWN,onSnowFallBtnDown);
            addChild(snowFallBtn);
            //「雪月下」ボタン設定
            snowNightBtn = new CustomButton("雪月下");
            snowNightBtn.x = 400;
            snowNightBtn.y = 60;
            snowNightBtn.addEventListener(MouseEvent.MOUSE_DOWN,onSnowNightBtnDown);
            addChild(snowNightBtn);
            //「ライトアップ」ボタン設定
            lightUpBtn = new CustomButton("ライトアップ");
            lightUpBtn.x = 400;
            lightUpBtn.y = 90;
            lightUpBtn.addEventListener(MouseEvent.MOUSE_DOWN,onLightUpBtnDown);
            addChild(lightUpBtn);
            //「Tweet」ボタン設定
            tweetBtn = new CustomButton("Tweet");
            tweetBtn.x = 400;
            tweetBtn.y = 150;
            tweetBtn.addEventListener(MouseEvent.MOUSE_DOWN,onTweetBtnDown);
            addChild(tweetBtn);
            //「祝木リスト」ボタン設定
            affiliateBtn = new CustomButton("祝木リスト");
            affiliateBtn.x = 400;
            affiliateBtn.y = 180;
            affiliateBtn.addEventListener(MouseEvent.MOUSE_DOWN,onAffiliateBtnDown);
            addChild(affiliateBtn);

            //「クエスト画面」ボタン設定
            goTitleScrnBtn = new CustomButton("タイトル画面");
            goTitleScrnBtn.x = 400;
            goTitleScrnBtn.y = 280;
            goTitleScrnBtn.addEventListener(MouseEvent.MOUSE_DOWN,goTitleScrnBtnDown);
            addChild(goTitleScrnBtn);

            forwardBtn = new CustomButton("前進");
            forwardBtn.x = 200;
            forwardBtn.y = 410;
            leftRotBtn = new CustomButton("左回転");
            leftRotBtn.x = 90;
            leftRotBtn.y = 440;
            bDashBtn = new CustomButton("Bダッシュ");
            bDashBtn.x = 200;
            bDashBtn.y = 440;
            rightRotBtn = new CustomButton("右回転");
            rightRotBtn.x = 310;
            rightRotBtn.y = 440;
            backwardBtn = new CustomButton("後退");
            backwardBtn.x = 200;
            backwardBtn.y = 470;
            forwardBtn.addEventListener(MouseEvent.MOUSE_DOWN,onForwardBtnDown);
            forwardBtn.addEventListener(MouseEvent.MOUSE_UP,onForwardBtnUp);
            forwardBtn.addEventListener(MouseEvent.MOUSE_OUT,onForwardBtnOut);
            leftRotBtn.addEventListener(MouseEvent.MOUSE_DOWN,onLeftRotBtnDown);
            leftRotBtn.addEventListener(MouseEvent.MOUSE_UP,onLeftRotBtnUp);
            leftRotBtn.addEventListener(MouseEvent.MOUSE_OUT,onLeftRotBtnOut);
            bDashBtn.addEventListener(MouseEvent.MOUSE_DOWN,onBDashBtnDown);
            bDashBtn.addEventListener(MouseEvent.MOUSE_UP,onBDashBtnUp);
            bDashBtn.addEventListener(MouseEvent.MOUSE_OUT,onBDashBtnOut);
            rightRotBtn.addEventListener(MouseEvent.MOUSE_DOWN,onRightRotBtnDown);
            rightRotBtn.addEventListener(MouseEvent.MOUSE_UP,onRightRotBtnUp);
            rightRotBtn.addEventListener(MouseEvent.MOUSE_OUT,onRightRotBtnOut);
            backwardBtn.addEventListener(MouseEvent.MOUSE_DOWN,onBackwardBtnDown);
            backwardBtn.addEventListener(MouseEvent.MOUSE_UP,onBackwardBtnUp);
            backwardBtn.addEventListener(MouseEvent.MOUSE_OUT,onBackwardBtnOut);
            addChild(forwardBtn);
            addChild(leftRotBtn);
            addChild(bDashBtn);
            addChild(rightRotBtn);
            addChild(backwardBtn);

            //ランド画面に遷移するまでボタンを非表示
            hideLandScrnBtn();
        }
        //ランド画面ボタンを非表示
        private function hideLandScrnBtn():void {
            resetBtn.visible = false;
            snowFallBtn.visible = false;
            snowNightBtn.visible = false;
            lightUpBtn.visible = false;
            tweetBtn.visible = false;
            affiliateBtn.visible = false;
            goTitleScrnBtn.visible = false;
            forwardBtn.visible = false;
            leftRotBtn.visible = false;
            rightRotBtn.visible = false;
            backwardBtn.visible = false;
            bDashBtn.visible = false;
        }
        //ランド画面ボタンを再表示
        private function dispLandScrnBtn():void {
            resetBtn.visible = true;
            snowFallBtn.visible = true;
            snowNightBtn.visible = true;
            lightUpBtn.visible = true;
            tweetBtn.visible = true;
            affiliateBtn.visible = true;
            goTitleScrnBtn.visible = true;
            forwardBtn.visible = true;
            leftRotBtn.visible = true;
            rightRotBtn.visible = true;
            backwardBtn.visible = true;
            bDashBtn.visible = true;
        }
//■■■ランド画面ボタン初期化エンド■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
//■■■3D空間を初期化スタート■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
        //3D空間を初期化
        private function init3DSpace():void {
            //ビューポート生成
            viewport = new Viewport3D(500, 500, false, true);
            viewport.opaqueBackground = 0x0055FF;
            addChild(viewport);

            //シーン生成
            scene = new Scene3D();

            //レンダリングエンジン生成
            renderer = new BasicRenderEngine();

             //カメラ設定
            camera = new Camera3D();
            camera.y = 200;
            camera.target = DisplayObject3D.ZERO;

            //タイトル文字の設定　引数は色コード・透過度
            letterformat = new Letter3DMaterial(0xFF9999 , 0.9);
            letterformat.doubleSided = true
            title3DText = new Text3D("Winter Snow" , new HelveticaBold() , letterformat);
            title3DText.y += 400;
            title3DText.scale = 1;
            Objs["title3DText"] = title3DText;
            scene.addChild(Objs["title3DText"], "title3DText");

            //最初のクエスト画面用に3Dオブジェクト初期化
            var tempBlueColorMaterial : ColorMaterial = new ColorMaterial(0x0000EE, 0.5);
            tempBlueColorMaterial.doubleSided = true;
            var tempRedColorMaterial : ColorMaterial = new ColorMaterial(0xEE0000, 0.5);
            tempRedColorMaterial.doubleSided = true;
            var tempGreenColorMaterial : ColorMaterial = new ColorMaterial(0x00EE00, 0.5);
            tempGreenColorMaterial.doubleSided = true;
            materialList.addMaterial(tempRedColorMaterial, "front");
            materialList.addMaterial(tempBlueColorMaterial, "back");
            materialList.addMaterial(tempGreenColorMaterial, "right");
            materialList.addMaterial(tempBlueColorMaterial, "left");
            materialList.addMaterial(tempRedColorMaterial, "top");
            materialList.addMaterial(tempGreenColorMaterial, "bottom");
            //飾り用3Dクリスタル表示
            crystalBoxCube = new Cube(materialList, 350, 350, 350);
            Objs["crystalBoxCube"] = crystalBoxCube;
            scene.addChild(Objs["crystalBoxCube"], "crystalBoxCube");

            //ランド画面土台Planeオブジェクト設定
            for (var xIndex:int = 0; xIndex < 10; xIndex++){
            for (var zIndex:int = 0; zIndex < 10; zIndex++){
                //3DPlaneオブジェクトの設定
                material = new ColorMaterial( 0xFFFFFF, 1 );
                material.doubleSided = true;
                material.smooth = true;
                material.interactive = true;  
                planeObj= new Plane(material, 290, 290, 1, 1); 
                planeObj.addEventListener(InteractiveScene3DEvent.OBJECT_CLICK, mouseClickPlane);
                planeObj.name = "planeX" + xIndex + "_Z" + zIndex;
                planeObj.x = (300 * xIndex);
                planeObj.z = 300 * zIndex;
                planeObj.rotationX += 90;
                planeObj.name = "snowGround";
                //Planeオブジェクトに名前を割り振り
                //7行3列の場合の名前例："planeX7_Z3"
                tempPlaneName = "planeX" + xIndex + "_Z" + zIndex;
                Objs[tempPlaneName] = planeObj;
                }
            }

            //3DPlaneオブジェクトによるクリスマスツリーの初期化
            initChristmasTree();

            //フィルターの準備
            filterList = new Array();
            var glowFilter : GlowFilter = new GlowFilter(0xFFFFFF, 1, 32, 32, 2, 1, false, false); 
            filterList.push(glowFilter);
            //Sphereによる月を設定
            var moonMaterial : ColorMaterial = new ColorMaterial(0xEEEE00, 0.7);
            moonSphere = new Sphere(moonMaterial, 80, 12, 9);
            moonSphere.useOwnContainer = true;
            moonSphere.filters = filterList; //フィルター使用のために設定
            moonSphere.y = 5500;
            moonSphere.x = 1350;
            moonSphere.z = 3000;
            Objs["moonSphere"] = moonSphere;

            //BlurFilter効果のついた光るピクセルを設定
            var layer:BitmapEffectLayer=new BitmapEffectLayer(viewport, 500, 500, true, 0, BitmapClearMode.CLEAR_PRE, true);
            viewport.containerSprite.addLayer(layer);
            layer.addEffect(new BitmapLayerEffect(new BlurFilter(8, 8, 4), false));
            pixels=new Pixels(layer);
            for(var x:Number=0; x < 6; x++){
                for(var z:Number=0; z < 6; z++){
                     for(var y:Number=0; y < 50; y++){
                         var p:Pixel3D=new Pixel3D((0xff << 24 | 0xff*Math.random() << 16 | 0xff << 8 | 0xff*Math.random()), 
                                                   x*600,
                                                   y*90,
                                                   z*600);
                         pixels.addPixel3D(p);
                     }
                }
            }
            pixels.rotationX -= 90;
            Objs["pixels"] = pixels;

            //操作用Arrowオブジェクト設定
            arrow = new Arrow(new WireframeMaterial(0x000000));
            Objs["arrow"] = arrow;

            //Particlesオブジェクト設定
            //生成するパーティクルの設定。色とアルファ値
            //particleMat = new ParticleMaterial(0xFF9999, 1);
            particleMat = new ParticleMaterial(0xFFFFFF, 1, ParticleMaterial.SHAPE_CIRCLE);
            //大きさ3000の立方体の中に大きさ8のパーティクルを1000個生成
            pFieldHeight = 3000;
            numParticles = 2000;
            fieldSize = 3000;
            particleField = new ParticleField(particleMat, numParticles, 8, fieldSize, pFieldHeight, fieldSize);
            for( var i:int = 0; i < numParticles; i++ )
            {
                Particle(particleField.particles[i]).size = Math.random() * 10 + 1;
            }
            particleField.y = pFieldHeight / 2;
            particleField.x = 1500;
            particleField.z = 1500;
            windOffset = new Array( 3 ); //wind offset
            windOffset[0] = 3;
            windOffset[1] = 5;
            windOffset[2] = 0;

            Objs["particleMat"] = particleMat;
            Objs["particleField"] = particleField;

            //マウスイベント処理用リスナを設定
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
        }

        //3DPlaneオブジェクトによるクリスマスツリーの初期化を行う
        private function initChristmasTree():void{
            var xLinePhase : int = 0;
            //3DPlaneオブジェクトによるクリスマスツリーの本体部分を設定
            for (var yTreeIndex:int = 0; yTreeIndex < 10; yTreeIndex++){
                //y軸2進むごとに、x軸に沿ったPlaneの表示数を2つ減らすための処理
                if (yTreeIndex == 2) {xLinePhase = 1}
                if (yTreeIndex == 4) {xLinePhase = 2}
                if (yTreeIndex == 6) {xLinePhase = 3}
                if (yTreeIndex == 8) {xLinePhase = 4}
                for (var xTreeIndex:int = 0; xTreeIndex < (10 - (xLinePhase*2)); xTreeIndex++){
                    //3DPlaneオブジェクトの設定
                    material = new ColorMaterial( 0x00FF00, 1 );
                    material.doubleSided = true;
                    material.smooth = true;
                    material.interactive = true;  
                    planeObj= new Plane(material, 290, 290, 1, 1); 
                    planeObj.addEventListener(InteractiveScene3DEvent.OBJECT_CLICK, mouseClickPlaneTree);
                    planeObj.name = "planeTreeX" + xTreeIndex + "_Y" + yTreeIndex;
                    planeObj.x = (300 * xLinePhase) + (300 * xTreeIndex);
                    planeObj.y = 1100 + (300 * yTreeIndex);
                    planeObj.z = 1500;
                    planeObj.name = "green";
                    //Planeオブジェクトに名前を割り振り
                    //7行3列の場合の名前例："planeTreeX7_Y3"
                    tempPlaneName = "planeTreeX" + xTreeIndex + "_Y" + yTreeIndex;
                    Objs[tempPlaneName] = planeObj;
                }
            }

            //3DPlaneオブジェクトによるクリスマスツリーの茎部分を設定
            for (var yTreeStemIndex:int = 0; yTreeStemIndex < 3; yTreeStemIndex++){
                for (var xTreeStemIndex:int = 0; xTreeStemIndex < 2; xTreeStemIndex++){
                    //3DPlaneオブジェクトの設定
                    material = new ColorMaterial( 0xFF9900, 1 );
                    material.doubleSided = true;
                    material.smooth = true;
                    planeObj= new Plane(material, 290, 290, 1, 1); 
                    planeObj.name = "planeTreeStemX" + xTreeStemIndex + "_Y" + yTreeStemIndex;
                    planeObj.x = 1200 + (300 * xTreeStemIndex);
                    planeObj.y = 200 + (300 * yTreeStemIndex);
                    planeObj.z = 1500;
                    planeObj.name = "stem";
                    //Planeオブジェクトに名前を割り振り
                    //7行3列の場合の名前例："planeTreeX7_Y3"
                    tempPlaneName = "planeTreeStemX" + xTreeStemIndex + "_Y" + yTreeStemIndex;
                    Objs[tempPlaneName] = planeObj;
                }
            }

            //3DPlaneオブジェクトによるクリスマスツリー頂点の星を設定
            material = new ColorMaterial( 0xFFFF00, 1 );
            material.doubleSided = true;
            material.smooth = true;
            starPlaneOne = new Plane(material, 500, 500, 1, 1); 
            starPlaneOne.x = 1350;
            starPlaneOne.y = 4300;
            starPlaneOne.z = 1500;
            starPlaneOne.name = "treeStar";
            starPlaneTwo = new Plane(material, 500, 500, 1, 1); 
            starPlaneTwo.rotationZ += 45;
            starPlaneOne.addChild(starPlaneTwo);
            Objs["treeStar"] = starPlaneOne;
        }
//■■■イベント処理スタート■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
        //イベント処理
        private function onEnterFrame(e:Event):void{
            if (screenId == TITLE_SCREEN_ID) {
                title3DText.rotationX -= 10;
                crystalBoxCube.rotationX = viewport.mouseY; //飾り用クリスタルの座標をマウス座標から設定
                crystalBoxCube.rotationY = viewport.mouseX; //飾り用クリスタルの座標をマウス座標から設定
                setCameraForTitleScrn(); //カメラ視点設定
                renderer.renderScene(scene, camera, viewport);
            } else if (screenId == LAND_SCREEN_ID) {
                if (snowFallState == true) { pouringParticles(); }//桜散る動きを設定
                calcArrowPos(); //操作用矢印座標を設定
                setCameraForLandScrn(); //カメラ視点設定
                renderer.renderScene(scene, camera, viewport);
            }
        }
        //ランド画面の操作用矢印座標を設定
        private function calcArrowPos():void{
            if (forwardState == true) {//前進
                arrow.moveForward(70);
            } else if (backwardState == true) {//後退
                arrow.moveForward(-70);
            } else if (leftRotState == true) {//左回転
                arrow.rotationY -= 10;
            } else if (rightRotState == true) {//右回転
                arrow.rotationY += 10;
            } else if (bDashState == true) {//Bダッシュ
                arrow.moveForward(100);
            }
        }
        //タイトル画面用カメラ視点設定
        private function setCameraForTitleScrn():void{
            var cameraDist : int = -1000; //デフォルトの距離、ステータスは1
            camera.x=cameraDist*Math.cos((90-crystalBoxCube.rotationY)*Math.PI/180)+crystalBoxCube.x;  
            camera.z=cameraDist*Math.sin((90-crystalBoxCube.rotationY)*Math.PI/180)+crystalBoxCube.z;
            camera.target.x=crystalBoxCube.x;
            camera.target.y=crystalBoxCube.y;
            camera.target.z=crystalBoxCube.z;
            cameraPitch = 90; //カメラのX軸回転の値　
            cameraYaw = 270; //カメラのY軸回転の値
            camera.orbit(cameraPitch, cameraYaw, true, crystalBoxCube);
        }
        //ランド画面用カメラ視点設定
        private function setCameraForLandScrn():void{
            var cameraDist : int = -1000; //デフォルトの距離、ステータスは1
            if (cameraDistStat == 0) {
                cameraDist = -500;
            } else if (cameraDistStat == 1) {
                cameraDist = -1500;
            } else if (cameraDistStat == 2) {
                cameraDist = -2500;
            } else if (cameraDistStat == 3) {
                cameraDist = -3500;
            } else if (cameraDistStat == 4) {
                cameraDist = -4500;
            } else if (cameraDistStat == 5) {
                cameraDist = -5500;
            } else if (cameraDistStat == 6) {
                cameraDist = -6500;
            } else if (cameraDistStat == 7) {
                cameraDist = -7500;
            }
            camera.x=cameraDist*Math.cos((90-arrow.rotationY)*Math.PI/180)+arrow.x;  
            camera.z=cameraDist*Math.sin((90-arrow.rotationY)*Math.PI/180)+arrow.z;
            camera.target.x=arrow.x;
            camera.target.y=arrow.y;
            camera.target.z=arrow.z;
            camera.orbit(cameraPitch, cameraYaw, true, arrow);
        }
        //雪が降り注ぐ動き
        private function pouringParticles():void
        {
            theta += Math.PI * 2 / 100;
            for( var iString:String in particleField.geometry.vertices ) {
                var i:int = int( iString );
                particleField.particles[i].y -= ( Particle( particleField.particles[ i ] ).size / 1.5 + windOffset[2] );
                particleField.particles[i].x += ( Math.sin( theta + i ) * 3 + windOffset[0] );
                particleField.particles[i].z += ( Math.cos( theta + i ) * 3 + windOffset[1] );
                if( particleField.particles[i].y < - pFieldHeight / 2 ) {
                    particleField.particles[i].y = pFieldHeight;
                }
                particleField.particles[i].x = (particleField.particles[i].x + fieldSize/2 ) % fieldSize - fieldSize/2;
                particleField.particles[i].z = (particleField.particles[i].z + fieldSize/2 ) % fieldSize - fieldSize/2;
            }
        }
        //キーボードイベント処理(押下時処理)
        private function onKeyDown(event:KeyboardEvent):void{
            if (screenId == TITLE_SCREEN_ID) {return;} //クエスト画面の場合は何も処理を行わない
            //Aボタン　操作オブジェクトを中心にカメラを左回り回転(Y軸回転)
            //4度づつ左回り回転  
            if (event.keyCode == 65) {
                cameraYaw = cameraYaw - 4;
                if(cameraYaw < 0) {cameraYaw = 360;}
            //Dボタン　操作オブジェクトを中心にカメラを右回り回転(Y軸回転)    
            //4度づつ右回り回転
            } else if (event.keyCode == 68) {
                cameraYaw = cameraYaw + 4;
                if(cameraYaw > 360) {cameraYaw = 0;}
            //Wボタン　操作オブジェクトを中心にカメラを上下移動(X軸回転)
            } else if (event.keyCode == 87) {        
                if(cameraPitch > 40) {cameraPitch = cameraPitch - 10;}
            //Sボタン　操作オブジェクトを中心にカメラを上下移動(X軸回転)
            } else if (event.keyCode == 83) {           
                if(cameraPitch < 110) {cameraPitch = cameraPitch + 10;}
            //Fボタン　カメラと操作オブジェクトの距離を変更
            } else if (event.keyCode == 70) {
                cameraDistStat -= 1;
                if(cameraDistStat < 0) {cameraDistStat = 7;}
            //Rボタン　カメラの設定をデフォルトにもどす
            } else if (event.keyCode == 82) {
                cameraDistStat = 7;
                cameraPitch = 50; //カメラのX軸回転の値　
                cameraYaw = 270; //カメラのY軸回転の値
            }
        }
        //ランド画面土台Planeオブジェクトクリック時処理　緑色→白色(雪の積もった地面)→白色＋白い木(雪の積もった木)→緑色
        private function mouseClickPlane(e:InteractiveScene3DEvent):void {
            var tempPlane : Plane = (DisplayObject3D(e.target)) as Plane;
            var tempMaterial : ColorMaterial;
            if (tempPlane.name == "snowGround") {
                tempMaterial = new ColorMaterial( 0xFFFFFF, 1 );
                tempMaterial.doubleSided = true;
                tempMaterial.smooth = true;
                tempMaterial.interactive = true;  
                tempPlane.material = tempMaterial;
                tempPlane.name = "snowTree"
                //雪の積もった木もどき3Dオブジェクト生成
                var tempCylinder : Cylinder = new Cylinder( new ColorMaterial( 0xFF9900, 1 ), 40, 200, 8, 8);
                tempCylinder.z -= 100
                tempCylinder.rotationX += 90;
                var tempCone : Cone = new Cone( new ColorMaterial( 0xFFFFFF, 1 ), 130, 200, 8, 8);
                tempCone.y -= 100
                tempCone.rotationX += 180;
                tempCylinder.addChild(tempCone);
                tempPlane.addChild(tempCylinder, "planeTree");
            } else { //tempPlane.name == "snowTree"
                tempMaterial = new ColorMaterial( 0xFFFFFF, 1 );
                tempMaterial.doubleSided = true;
                tempMaterial.smooth = true;
                tempMaterial.interactive = true;  
                tempPlane.material = tempMaterial;  
                tempPlane.name = "snowGround"
                tempPlane.removeChildByName("planeTree");
            }
            
        }
        //3DPlaneオブジェクトによるツリーをクリック時処理　緑→赤→青→黄→白→緑
        private function mouseClickPlaneTree(e:InteractiveScene3DEvent):void {
            var tempPlane : Plane = (DisplayObject3D(e.target)) as Plane;
            var tempMaterial : ColorMaterial;
            if (tempPlane.name == "green") {
                tempMaterial = new ColorMaterial( 0xFF0000, 1 );
                tempMaterial.doubleSided = true;
                tempMaterial.smooth = true;
                tempMaterial.interactive = true;  
                tempPlane.material = tempMaterial;
                tempPlane.name = "red"
            }  else if (tempPlane.name == "red") {
                tempMaterial = new ColorMaterial( 0x0000FF, 1 );
                tempMaterial.doubleSided = true;
                tempMaterial.smooth = true;
                tempMaterial.interactive = true;  
                tempPlane.material = tempMaterial;
                tempPlane.name = "blue"
            }   else if (tempPlane.name == "blue") {
                tempMaterial = new ColorMaterial( 0xFFFF00, 1 );
                tempMaterial.doubleSided = true;
                tempMaterial.smooth = true;
                tempMaterial.interactive = true;  
                tempPlane.material = tempMaterial;
                tempPlane.name = "yellow"
            }   else if (tempPlane.name == "yellow") {
                tempMaterial = new ColorMaterial( 0xFFFFFF, 1 );
                tempMaterial.doubleSided = true;
                tempMaterial.smooth = true;
                tempMaterial.interactive = true;  
                tempPlane.material = tempMaterial;
                tempPlane.name = "white"
            } else { //tempPlane.name == "white"
                tempMaterial = new ColorMaterial( 0x00FF00, 1 );
                tempMaterial.doubleSided = true;
                tempMaterial.smooth = true;
                tempMaterial.interactive = true;  
                tempPlane.material = tempMaterial;  
                tempPlane.name = "green"
            }
            
        }
//■■■イベント処理エンド■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
//■■■3D空間を初期化エンド■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
//■■■ボタン処理スタート■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
//■■■画面遷移ボタン処理スタート■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
        //タイトル画面からランド画面に遷移
        private function goLandScrnBtnDown(evt:MouseEvent):void {
            hideTitleScrnBtn(); //タイトル画面ボタンを非表示
            dispLandScrnBtn(); //ランド画面ボタンを表示

            //3Dオブジェクト表示・非表示処理
            removeTitleScrn3DObjs();
            addLandScrn3DObjs();

            addLandScrnTxt(); //ランド画面情報テキストを設定

            //スクリーンID設定
            screenId = LAND_SCREEN_ID;

            //ランド画面用のカメラ初期設定
            cameraDistStat = 7;
            cameraPitch = 50;
        }

        //ランド画面からタイトル画面に遷移
        private function goTitleScrnBtnDown(evt:MouseEvent):void {
            hideLandScrnBtn(); //ランド画面ボタンを非表示
            dispTitleScrnBtn(); //タイトル画面ボタンを表示

            //3Dオブジェクト表示・非表示処理
            removeLandScrn3DObjs();
            addTitleScrn3DObjs();

            removeLandScrnTxt(); //ランド画面情報テキストを設定解除

            //スクリーンID設定
            screenId = TITLE_SCREEN_ID;
        }

        //タイトル画面に3Dオブジェクトをセット
        private function addTitleScrn3DObjs():void {
            scene.addChild(Objs["title3DText"], "title3DText");
            scene.addChild(Objs["crystalBoxCube"], "crystalBoxCube");
        }
        //タイトル画面に3Dオブジェクトをリリース
        private function removeTitleScrn3DObjs():void {
            scene.removeChildByName("title3DText");
            scene.removeChildByName("crystalBoxCube");
        }
        //ランド画面に3Dオブジェクトをセット
        private function addLandScrn3DObjs():void {
            //3DPlaneオブジェクトによるフィールド部分を表示
            for (var xIndex:int = 0; xIndex < 10; xIndex++){
                for (var zIndex:int = 0; zIndex < 10; zIndex++){
                    //3DPlaneオブジェクトを取り出す
                    //Planeオブジェクト取り出し用の名前を作成  7行3列の場合の名前例："planeX7_Z3" 
                    tempPlaneName = "planeX" + xIndex + "_Z" + zIndex;
                    scene.addChild(Objs[tempPlaneName], tempPlaneName);
                }
            }
            //3DPlaneオブジェクトによるクリスマスツリーの本体部分を表示
            var xLinePhase : int = 0;
            //ランド画面土台Planeオブジェクト設定
            for (var yTreeIndex:int = 0; yTreeIndex < 10; yTreeIndex++){
                //y軸2行進むごとにx軸に沿ったPlaneの表示数を2つ減らすための処理
                if (yTreeIndex == 2) {xLinePhase = 1}
                if (yTreeIndex == 4) {xLinePhase = 2}
                if (yTreeIndex == 6) {xLinePhase = 3}
                if (yTreeIndex == 8) {xLinePhase = 4}
                for (var xTreeIndex:int = 0; xTreeIndex < (10 - (xLinePhase*2)); xTreeIndex++){
                    //3DPlaneオブジェクトを取り出す
                    //Planeオブジェクト取り出し用の名前を作成  7行3列の場合の名前例："planeTreeX7_Y3" 
                    tempPlaneName = "planeTreeX" + xTreeIndex + "_Y" + yTreeIndex;
                    scene.addChild(Objs[tempPlaneName], tempPlaneName);
                }
            }
            //3DPlaneオブジェクトによるクリスマスツリーの茎部分を表示
            for (var yTreeStemIndex:int = 0; yTreeStemIndex < 3; yTreeStemIndex++){
                for (var xTreeStemIndex:int = 0; xTreeStemIndex < 2; xTreeStemIndex++){
                    //3DPlaneオブジェクトを取り出す
                    //Planeオブジェクト取り出し用の名前を作成  7行3列の場合の名前例："planeTreeX7_Y3" 
                    tempPlaneName = "planeTreeStemX" + xTreeStemIndex + "_Y" + yTreeStemIndex;
                    scene.addChild(Objs[tempPlaneName], tempPlaneName);
                }
            }
            //3DPlaneオブジェクトによるクリスマスツリー頂点の星を表示
            scene.addChild(Objs["treeStar"], "treeStar");

            arrow = Objs["arrow"];
            //操作矢印を初期化
            arrow.y = 50;
            arrow.x = 1350; 
            arrow.z = 1350;
            arrow.rotationY = 0;
            scene.addChild(arrow, "arrow");

        }
        //ランド画面から3Dオブジェクトをリリース
        private function removeLandScrn3DObjs():void {
            //3DPlaneオブジェクトによるフィールド部分をリリース
            //ランドマップ配列1行分の処理
            for (var xIndex:int = 0; xIndex < 10; xIndex++){
                //配列1行分の10列のデータを処理
                for (var zIndex:int = 0; zIndex < 10; zIndex++){
                    //3DPlaneオブジェクトをリリース
                    //Planeオブジェクト取り出し用の名前を作成  3行7列の場合の名前例："planeX3_Y7" 
                    tempPlaneName = "planeX" + xIndex + "_Z" + zIndex;
                    scene.removeChildByName(tempPlaneName);
                }
            }
            //3DPlaneオブジェクトによるクリスマスツリーの本体部分をリリース
            //10*10列のデータとしてリリース処理
            for (var yTreeIndex:int = 0; yTreeIndex < 10; yTreeIndex++){
                for (var xTreeIndex:int = 0; xTreeIndex < 10; xTreeIndex++){
                    //3DPlaneオブジェクトをリリース
                    //Planeオブジェクト取り出し用の名前を作成  2行3列の場合の名前例："planeTreeX2_Y3" 
                    tempPlaneName = "planeTreeX" + xTreeIndex + "_Y" + yTreeIndex;
                    scene.removeChildByName(tempPlaneName);
                }
            }
            //3DPlaneオブジェクトによるクリスマスツリーの茎部分をリリース
            for (var yTreeStemIndex:int = 0; yTreeStemIndex < 3; yTreeStemIndex++){
                for (var xTreeStemIndex:int = 0; xTreeStemIndex < 2; xTreeStemIndex++){
                    //3DPlaneオブジェクトをリリース
                    //Planeオブジェクト取り出し用の名前を作成  1行1列の場合の名前例："planeTreeStemX1_Y1" 
                    tempPlaneName = "planeTreeStemX" + xTreeStemIndex + "_Y" + yTreeStemIndex;
                    scene.removeChildByName(tempPlaneName);
                }
            }
            //3DPlaneオブジェクトによるクリスマスツリー頂点の星をリリース
            scene.removeChildByName("treeStar");

            scene.removeChildByName("arrow");
            scene.removeChildByName("particleField");
            snowFallState = false;
        }
//■■■画面遷移ボタン処理エンド■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
//■■■ランド画面ボタン処理スタート(遷移ボタン以外)■■■■■■■■■■■■■■■■■■■■■■■■
        //リセット機能(ランド区画のみ初期化)
        private function onResetBtnDown(evt:MouseEvent):void {
            //ランド区画を初期化
            resetLandMap();
        }
        //リセット処理
        private function resetLandMap():void {
            var tempPlane : Plane;
            var tempMaterial : ColorMaterial;
            //3DPlaneによるフィールドを初期化
            for (var xIndex:int = 0; xIndex < 10; xIndex++){
                for (var zIndex:int = 0; zIndex < 10; zIndex++){
                    //リセット処理
                    tempPlaneName = "planeX" + xIndex + "_Z" + zIndex;
                    tempPlane = (scene.getChildByName(tempPlaneName)) as Plane;
                    if(tempPlane != null) {
                        tempMaterial = new ColorMaterial( 0xFFFFFF, 1 );
                        tempMaterial.doubleSided = true;
                        tempMaterial.smooth = true;
                        tempMaterial.interactive = true;  
                        tempPlane.material = tempMaterial;
                        if (tempPlane.name == "snowTree") {
                            tempPlane.removeChildByName("planeTree");
                        }
                        tempPlane.name = "snowGround"
                    }
                }
            }
            //3DPlaneによるクリスマスツリー本体を初期化
            for (var yTreeIndex:int = 0; yTreeIndex < 10; yTreeIndex++){
                for (var xTreeIndex:int = 0; xTreeIndex < 10; xTreeIndex++){
                    //フィルターセット処理
                    tempPlaneName = "planeTreeX" + xTreeIndex + "_Y" + yTreeIndex;
                    tempPlane = (scene.getChildByName(tempPlaneName)) as Plane;
                    if(tempPlane != null) {
                        tempMaterial = new ColorMaterial( 0x00FF00, 1 );
                        tempMaterial.doubleSided = true;
                        tempMaterial.smooth = true;
                        tempMaterial.interactive = true;  
                        tempPlane.material = tempMaterial;
                        tempPlane.name = "green"
                    }
                }
            }
        }
        //「降雪」機能
        private function onSnowFallBtnDown(evt:MouseEvent):void {
            //落ちる雪に見立てたパーティクルをON・OFF
            if (snowFallState == false) {
                //パーティクル設定
                particleField = Objs["particleField"]
                scene.addChild(particleField, "particleField");
                snowFallState = true;
            } else {
                scene.removeChildByName("particleField");
                snowFallState = false;
            } 
        }
        //「雪月下」機能
        private function onSnowNightBtnDown(evt:MouseEvent):void {
            //フィルターを使って雪月花を表現
            var tempPlane : Plane;
            if (snowNightState == false) {//「雪月下」表現を設定する
                viewport.opaqueBackground = 0x333333;
                moonSphere = Objs["moonSphere"];
                scene.addChild(moonSphere, "moonSphere");
                //3DPlaneオブジェクトによるクリスマスツリーの本体部分にフィルターを設定
                for (var yTreeIndex:int = 0; yTreeIndex < 10; yTreeIndex++){
                    for (var xTreeIndex:int = 0; xTreeIndex < 10; xTreeIndex++){
                        //フィルターセット処理
                        tempPlaneName = "planeTreeX" + xTreeIndex + "_Y" + yTreeIndex;
                        tempPlane = (scene.getChildByName(tempPlaneName)) as Plane;
                        if(tempPlane != null) {
                            tempPlane.useOwnContainer = true; //フィルター使用のために設定
                            tempPlane.filters = filterList;
                        }
                    }
                }
                //3DPlaneオブジェクトによるクリスマスツリーの茎部分にフィルターを設定
                for (var yTreeStemIndex:int = 0; yTreeStemIndex < 3; yTreeStemIndex++){
                    for (var xTreeStemIndex:int = 0; xTreeStemIndex < 2; xTreeStemIndex++){
                        //フィルターセット処理
                        tempPlaneName = "planeTreeStemX" + xTreeStemIndex + "_Y" + yTreeStemIndex;
                        tempPlane = (scene.getChildByName(tempPlaneName)) as Plane;
                        if(tempPlane != null) {
                            tempPlane.useOwnContainer = true; //フィルター使用のために設定
                            tempPlane.filters = filterList;
                        }
                    }
                }
                //3DPlaneオブジェクトによるクリスマスツリー頂点の星にフィルターを設定
                tempPlane = (scene.getChildByName("treeStar")) as Plane;
                if(tempPlane != null) {
                    tempPlane.useOwnContainer = true; //フィルター使用のために設定
                    tempPlane.filters = filterList;
                }
                snowNightState = true;
            } else {//「雪月下」表現を解除する(snowNightState == true)
                viewport.opaqueBackground = 0x0055FF;
                scene.removeChildByName("moonSphere");
                //3DPlaneオブジェクトによるクリスマスツリーの本体部分のフィルターを解除
                for (var yTreeIndex:int = 0; yTreeIndex < 10; yTreeIndex++){
                    for (var xTreeIndex:int = 0; xTreeIndex < 10; xTreeIndex++){
                        //フィルターリセット処理
                        tempPlaneName = "planeTreeX" + xTreeIndex + "_Y" + yTreeIndex;
                        tempPlane = (scene.getChildByName(tempPlaneName)) as Plane;
                        if(tempPlane != null) {
                            tempPlane.useOwnContainer = false; //フィルター使用のための設定解除
                            tempPlane.filters = null;
                        }
                    }
                }
                //3DPlaneオブジェクトによるクリスマスツリーの茎部分のフィルターを解除
                for (var yTreeStemIndex:int = 0; yTreeStemIndex < 3; yTreeStemIndex++){
                    for (var xTreeStemIndex:int = 0; xTreeStemIndex < 2; xTreeStemIndex++){
                        //フィルターリセット処理
                        tempPlaneName = "planeTreeStemX" + xTreeStemIndex + "_Y" + yTreeStemIndex;
                        tempPlane = (scene.getChildByName(tempPlaneName)) as Plane;
                        if(tempPlane != null) {
                            tempPlane.useOwnContainer = false; //フィルター使用のための設定解除
                            tempPlane.filters = null;
                        }
                    }
                }
                //3DPlaneオブジェクトによるクリスマスツリー頂点の星のフィルターを解除
                tempPlane = (scene.getChildByName("treeStar")) as Plane;
                if(tempPlane != null) {
                    tempPlane.useOwnContainer = false; //フィルター使用のための設定解除
                    tempPlane.filters = null;
                }
                snowNightState = false;
            }
        }
        //「ライトアップ」機能
        private function onLightUpBtnDown(evt:MouseEvent):void {
            //BlurFilter効果を使ってライトアップを表現
            var tempPlane : Plane;
            if (lightUpState == false) {//「ライトアップ」表現を設定する
                tempPlane = (scene.getChildByName("planeX0_Z0")) as Plane; //Objs["planeX0_Z0"];
                pixels = Objs["pixels"];
                tempPlane.addChild(pixels, "pixels");
                lightUpState = true;
            } else {//「ライトアップ」表現を解除する(lightUpState == true)
                tempPlane = (scene.getChildByName("planeX0_Z0")) as Plane;
                tempPlane.removeChildByName("pixels");
                lightUpState = false;
            }
        }
        //「Tweet」ボタン押下時処理設定
        private function onTweetBtnDown(evt:MouseEvent):void {
            //var comment:String = "メリークリスマス！　私からのクリスマスツリーをどうぞ！！！ ";
            //var post:String = comment + " " + "http://wonderfl.net/c/pOjZ/" + " " + "#wonderfl" + " ";
            var post:String = TWEET_COMMENT + " " + CHRISTMAS_TREE_URL + " " + HASH_TAG_GROUP + " ";
            navigateToURL(new URLRequest("http://twitter.com/home?status=" + escapeMultiByte(post)), "_blank");
        }
        //「祝木リスト」ボタン押下時処理設定
        private function onAffiliateBtnDown(evt:MouseEvent):void {
            //var post:String = TWEET_COMMENT + " " + CHRISTMAS_TREE_URL + " " + HASH_TAG_GROUP + " ";
            navigateToURL(new URLRequest(AFFILIATE_URL), "_blank");
        }
        //前進ボタン押下時処理設定
        private function onForwardBtnDown(evt:MouseEvent):void {
            forwardState = true;
        }
        //前進ボタンリリース時処理設定1
        private function onForwardBtnUp(evt:MouseEvent):void {
            forwardState = false;
        }
        //前進ボタンリリース時処理設定2
        private function onForwardBtnOut(evt:MouseEvent):void {
            forwardState = false;
        }
        //後退ボタン押下時処理設定
        private function onBackwardBtnDown(evt:MouseEvent):void {
            backwardState = true;
        }
        //後退ボタンリリース時処理設定1
        private function onBackwardBtnUp(evt:MouseEvent):void {
            backwardState = false;
        }
        //後退ボタンリリース時処理設定2
        private function onBackwardBtnOut(evt:MouseEvent):void {
            backwardState = false;
        }
        //左回転ボタン押下時処理設定
        private function onLeftRotBtnDown(evt:MouseEvent):void {
            leftRotState = true;
        }
        //左回転ボタンリリース時処理設定1
        private function onLeftRotBtnUp(evt:MouseEvent):void {
            leftRotState = false;
        }
        //左回転ボタンリリース時処理設定2
        private function onLeftRotBtnOut(evt:MouseEvent):void {
            leftRotState = false;
        }
        //右回転ボタン押下時処理設定
        private function onRightRotBtnDown(evt:MouseEvent):void {
            rightRotState = true;
        }
        //右回転ボタンリリース時処理設定1
        private function onRightRotBtnUp(evt:MouseEvent):void {
            rightRotState = false;
        }
        //右回転ボタンリリース時処理設定2
        private function onRightRotBtnOut(evt:MouseEvent):void {
            rightRotState = false;
        }
        //Bダッシュボタン押下時処理設定
        private function onBDashBtnDown(evt:MouseEvent):void {
            bDashState = true;
        }
        //Bダッシュボタンリリース時処理設定1
        private function onBDashBtnUp(evt:MouseEvent):void {
            bDashState = false;
        }
        //Bダッシュボタンリリース時処理設定2
        private function onBDashBtnOut(evt:MouseEvent):void {
            bDashState = false;
        }
//■■■ランド画面ボタン処理エンド(遷移ボタン以外)■■■■■■■■■■■■■■■■■■■■■■■■■
//■■■ボタン処理エンド■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
    }
}
//■■■カスタムボタンクラス■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
import flash.display.*;
import flash.system.*;
import flash.text.*;
//カスタムボタン
class CustomButton extends SimpleButton {
        private var btnName : String = "";//ボタン名
        private var btnNo : int = 0;//ボタン番号
        //コンストラクタ    
        public function CustomButton(label:String="",no:int=0) {
            btnName = label;
            btnNo = no;
            //状態
            upState = makeSprite(label,0x999999);
            overState = upState;
            downState = makeSprite(label,0x0000FF);
            hitTestState = upState;
        }
        public function getBtnName():String {
            return btnName;
        }
        public function getBtnNo():int {
            return btnNo;
        }
        //ボタン用スプライト作成
        private function makeSprite(text:String,color:uint):Sprite{
            //ボタン用ラベル作成
            var label : TextField = new TextField();
            label.text = text;
            label.autoSize = TextFieldAutoSize.CENTER;
            label.selectable = false;
            //ボタン用スプライト作成
            var sp:Sprite = new Sprite();
            sp.graphics.beginFill(color);
            sp.graphics.drawRoundRect(0, 0, 100, 20, 15);
            sp.graphics.endFill();
            sp.alpha = 0.8;            
            sp.addChild(label);
            //ラベル用フォーマット設定
            var format:TextFormat=new TextFormat();
            format.font = "Courier New";
            format.bold = true;
            format.size = 13;
            label.setTextFormat(format);
            return sp;
        }
}
//■■■ユーティリティクラス■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
import flash.text.TextField;
import flash.text.TextFormat;
import flash.text.AntiAliasType;
import flash.text.TextFormatAlign;
//ユーティリティ
class Util
{
    //テキストフィールドの生成
    public static function makeTxtField(posX:int,posY:int,width:int,height:int):TextField {
        var label:TextField=new TextField();
        label.selectable=false;
        label.x       =posX;
        label.y       =posY;
        label.width   =width;
        label.height  =height;
        label.antiAliasType=AntiAliasType.ADVANCED;
        return label;
    }
    //テキストフォーマットの生成
    public static function makeTextFormat(size:uint,color:uint,
        align:String=TextFormatAlign.LEFT):TextFormat {
        var format:TextFormat=new TextFormat();
        format.font ="Courier New"; // 等幅フォント
        format.size =size;  
        format.color=color;
        format.bold =true;
        format.align=align;
        return format;
    }
}