/**
 * Copyright milkmidi ( http://wonderfl.net/user/milkmidi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pO6w
 */

/*
 * http://milkmidi.com
 * http://milkmidi.blogspot.com
 * */
package {
	import flash.display.*;
	import flash.events.*;
	import org.papervision3d.core.proto.MaterialObject3D;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.materials.utils.MaterialsList;	
	import org.papervision3d.objects.primitives.Cube;	
	import org.papervision3d.view.BasicView;	
	import org.papervision3d.events.*;
	import caurina.transitions.Tweener;
	public class CubeInteractive extends BasicView	{		
		private var _cube		:Cube;
		private var _isRotation	:Boolean = true;//是否旋轉
		public function CubeInteractive(){
			super(0, 0, true, true);			
			camera.y = 300;
			camera.focus = 15;
			init3DObject();
			startRendering();
		}
		private function init3DObject():void {
			var _ml:MaterialsList = new MaterialsList(
			{
				front	:getMaterial("front"), 
				back	:getMaterial("back"), 
				left	:getMaterial("left"), 
				right	:getMaterial("right"),
				top		:getMaterial("top"), 
				bottom	:getMaterial("bottom")
			});
			_cube = new Cube(_ml, 300, 300, 300);			
			_cube.addEventListener(InteractiveScene3DEvent.OBJECT_CLICK , _cubeClickHandler);
			scene.addChild(_cube);
		}
		private function getMaterial(pName:String):MaterialObject3D {
			var _colorMat:ColorMaterial = new ColorMaterial(Math.random() * 0xffffff);
			_colorMat.interactive = true;
			_colorMat.name = pName;
			//給預材質一個名稱, 好用來做判斷。
			return _colorMat;
		}
		private function _cubeClickHandler(e:InteractiveScene3DEvent):void {			
			if (_isRotation == false) {
				//如果不是在旋轉，就回到旋轉模式
				_isRotation = true;
				return;
			}
			_isRotation = false;
			var _obj:Object;
			//透過e.face3d, 可以得到點擊時, 面的物件
			//再透過其當下的 material.name來做判斷, 就可以知道那一面被按下
			switch (e.face3d.material.name) {
				case "front" :			
					_obj = { rotationX:0 , rotationY:180 , rotationZ:0 };	break;
				case "back" :
					_obj = { rotationX:0 , rotationY:0 , rotationZ:0 };		break;
				case "left" :
					_obj = { rotationX:0 , rotationY: -90 , rotationZ:0 };	break;
				case "right" :
					_obj = { rotationX:0 , rotationY:90 , rotationZ:0 };	break;
				case "top" :
					_obj = { rotationX:90 , rotationY:0 , rotationZ:0 };	break;
				case "bottom" :
					_obj = { rotationX: -90 , rotationY:0 , rotationZ:180 };break;
			}
			_obj.time = 1;			
			Tweener.addTween(_cube, _obj );
		}
		override protected function onRenderTick(event:Event = null):void {
			super.onRenderTick(event);		
			if (_isRotation) {
				var _targetX:Number = (stage.stageWidth * .5 - mouseX) / 40;
				var _targetY:Number = (stage.stageHeight * .5 - mouseY) / 40;				
				_cube.rotationY += _targetX;
				_cube.rotationX += _targetY;
			}			
		}
	}
}