/**
 * Copyright okoi ( http://wonderfl.net/user/okoi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pNu2
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.ProgressEvent;
    import flash.events.MouseEvent;    
    import flash.net.FileReference;
    import flash.net.FileFilter;
    
    [SWF(width = "465", height = "465")]
    
    /**
     * ...
     * @author 
     */
    public class Main extends Sprite 
    {
        public var fr:FileReference;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            stage.addEventListener(MouseEvent.CLICK, MouseClickHandler );
        }
        
        private function MouseClickHandler(e:MouseEvent) : void
        {
            OpenFileSelectDialog();
        }
        
        public function OpenFileSelectDialog() : void
        {
            fr = new FileReference();
            fr.addEventListener(Event.SELECT, FileSelectHandler);
            fr.addEventListener(Event.COMPLETE, FileLoadCompleteHandler);
            fr.addEventListener(ProgressEvent.PROGRESS, FileLoadProgressHandler);
            var filter:FileFilter = new FileFilter("All files", "*.*");    //    表示するファイルにフィルターをかける場合は使う
            fr.browse([filter]);
        }
        
        public function FileSelectHandler( e:Event ) : void
        {
            var target:FileReference = e.target as FileReference;
            trace("FileSelectHandler",     "FileName:" + target.name, "Extension:" + target.type, "FileSize:" + target.size );
            target.load();
        }
        
        public function FileLoadProgressHandler( e:ProgressEvent ) : void
        {
            trace(e.bytesLoaded, "/", e.bytesTotal, int(e.bytesLoaded/e.bytesTotal*100)+"%");
        }
        
        public function FileLoadCompleteHandler( e:Event ) : void
        {
            trace("FileLoadCompleteHandler");
            //    trace(e.target.data);
        }
        
    }
    
}