/**
 * Copyright Johannes ( http://wonderfl.net/user/Johannes )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pNkK
 */

package {
    import flash.events.*;
	import flash.display.*;
	import flash.geom.*;
	import flash.text.*;
    import org.papervision3d.materials.*;
	import org.papervision3d.materials.shadematerials.*;
	import org.papervision3d.lights.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.*;

	[SWF(backgroundColor='0x3CC9EE')]
    
    public class Sample3 extends BasicView {
		public var ground1:Plane;
		public var bg1:Plane;
		public var player:Sphere;
		public var keyboard:Vector.<Boolean> = new Vector.<Boolean>(255);
		public var xv:Number = 0;
		public var yv:Number = 0;
		public var mv:Number = 10;
		public var light:PointLight3D;
		public var groundContainer3D:Vector.<Plane> = new Vector.<Plane>;
		public var groundContainer:Vector.<RSpace> = new Vector.<RSpace>;
		public var css:StyleSheet;
		public var txt:TextField;
		
        public function Sample3():void {
			stage.quality = StageQuality.LOW;
			light = new PointLight3D(true);
			light.x = 0;
			light.z = 100;
			light.y = 200;
			ground1 = new Plane(new FlatShadeMaterial(light, 0x068903, 0x04AA00), 1000, 150, 15, 5);
			ground1.rotationX = 90;
			bg1 = new Plane(new FlatShadeMaterial(light, 0x7E5303, 0x916004), 1000, 200, 15, 5);
			bg1.y = -100;
			bg1.z = -75;
            player = new Sphere(new GouraudMaterial(light, 0x888888, 0x333333), 50, 8, 6);
			player.x = -460;
			player.y = 50;
			
			css = new StyleSheet();
			css.setStyle('p', {
				fontSize: 20,
				fontFamily: 'Verdana',
				display: 'inline',
				color: '#000000'
			});
			
			txt = new TextField();
			txt.styleSheet = css;
			txt.x = 5;
			txt.y = 5;
			txt.width = stage.stageWidth - 10;
			txt.height = 30;
			txt.textColor = 0x000000;
			txt.selectable = false;
			txt.htmlText = "<p>Gold: 0</p>";
			
			stage.addChild(txt);
			scene.addChild(ground1);
			scene.addChild(bg1);
            scene.addChild(player);
            startRendering();

            addEventListener(Event.ENTER_FRAME, loop);
			stage.addEventListener(KeyboardEvent.KEY_DOWN, kD);
			stage.addEventListener(KeyboardEvent.KEY_UP, kU);
			
			camera.target = player;
			camera.y = 100;
        }

		public function drawGround():void {}

		public function kD(e:KeyboardEvent):void {
			if(e.keyCode < 255) {
				keyboard[e.keyCode] = true;
			}
		}
		
		public function kU(e:KeyboardEvent):void {
			if(e.keyCode < 255) {
				keyboard[e.keyCode] = false;
			}
		}
		
		public function groundCollide():Boolean {
			return player.y < 51;
		}
        
        public function loop(e:Event):void {
			var dx:Number = -(camera.x - player.x);
			var dz:Number = camera.z - player.z;
			var d:Number = Math.sqrt(dx * dx + dz * dz);
			
            camera.x -= (camera.x - (player.x + dx / d * 250)) / 30;
			camera.y = 100 + player.y;
			camera.z -= (camera.z - (player.z + dz / d * 350)) / 10;
			
			if(keyboard[37]) { xv--; }
			if(keyboard[39]) { xv++; }
			if(xv > mv) xv = mv;
			if(xv < -mv) xv = -mv;
			if(!keyboard[37] && !keyboard[39]) { xv -= xv > 0 ? 1 : (xv < 0 ? -1 : 0); }
			
			player.y -= yv;
			
			if(!groundCollide()) {
				yv++;
			} else {
				yv = -Math.abs(yv * 0.7);
				
				if(yv > -2) {
					yv = 0;
				}
				
				if(keyboard[38]) {
					yv = -16;
				}
			}
			
			player.x += xv;
			player.rotationZ += -xv;
			
			light.x = player.x;
			light.y = player.y + 150;
			light.z = 0;
        }
    }
}

class RSpace {
	public var x:Number;
	public var y:Number;
	public var w:Number;
	public var h:Number;
	public var angle:Number;
	
	public function RSpace(_x:Number, _y:Number, _w:Number, _h:Number, _angle:Number) {
		x = _x;
		y = _y;
		w = _w;
		h = _h;
		angle = _angle;
	}
}
