/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pNbW
 */

package
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    
    public class Main extends Sprite
    {
        public function Main()
        {
            addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        }
        
        public function addedToStage($e:*) :void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
            init();
        }
        
        public function init() :void
        {
            Buffer.initContext(stage);
        }
    }
}

import flash.display.*;
import flash.events.*;
import flash.geom.*;
import flash.text.*;

class Buffer
{
    public static var CANVAS :Stage;
    public static var CC_FORECAST :CollisionForecast;
    public static var CHILDREN :Array;
    
    public static function initContext($canvas:Stage) :void
    { 
        CANVAS = $canvas;
        CC_FORECAST = new CollisionForecast();  // <-- define display objects
        CHILDREN = [CC_FORECAST];        // <-- predefine display objects within array instantiation
        
        initChildren();
    }
    
    public static function initChildren() :void
    {
        for (var $:int = 0; $<CHILDREN.length; $++)
        {
            CANVAS.addChild(CHILDREN[$]);
        }
    }
}

class CollisionForecast extends Sprite
{
    public function CollisionForecast()
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
    }
    
    public function addedToStage($e:*) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        init();
    }
    
    public function init() :void
    {
        graphics.clear();
        graphics.lineStyle(2);

        /*
        for (var $:int = 5; $<465; $+=5)
        {
            graphics.lineTo(($-2.5), ($-2.5));
            graphics.moveTo($, $);
        }*/
        drawDashedLine(new Point(400, 100));
    }
    
    public function drawDashedLine($pos:Point, $inc:int = 5) :void
    {
        var $calcX :int = ($pos.x/($pos.x/$inc));
        var $calcY :int = ($pos.y/($pos.y/$inc));
        
        /*
        for (var $x:int=$inc; $x<$pos.x; $x+=$inc)
        {
            for (var $y:int=$inc; $y<$pos.y; $y+=$inc)
            {
                graphics.lineTo(($x-($inc/2)), (($y-($inc/2))));
                graphics.moveTo($x, $y);
            }
        }*/
        
        for (var $:int=$inc; $<($pos.x+$pos.y); $+=$inc)
        {

            graphics.lineTo(($calcX*$inc)-2.5, ($calcY*$inc)-2.5);
            graphics.moveTo($calcX*$inc, $calcY*$inc);
        }
    }
}
