/**
 * Copyright hacker_ajhafuzn ( http://wonderfl.net/user/hacker_ajhafuzn )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pNYV
 */

// forked from yonatan's Array sort vs. Vector sort
 package {
    import flash.display.Sprite;
    import flash.utils.*;
    import flash.text.TextField;
    
    public class TraceTest extends Sprite {
        private var array:Array = new Array;
        private var vector:Vector.<Object> = new Vector.<Object>;
            
        public function TraceTest() {
            WTrace.initTrace(stage);

            var cnt:uint = 1000000;
            
            while( cnt-- ) {
                var obj:TestObject = new TestObject;
                obj.value = Math.random();
                array.push(obj);
                vector.push(obj);
            }
            
            trace( "Array sort: " + sortArray() + "ms" );
            trace( "Vector sort: " + sortVector() + "ms" );
        }
        
        private function sortArray():Number {
            var start:Number = getTimer();
            array.sortOn( "value", Array.NUMERIC );
            return getTimer() - start;
        }
        
        private function comp( a:TestObject, b:TestObject ):Number {
            return a.value - b.value;
        }

        private function sortVector():Number {
            var start:Number = getTimer();

            vector.sort( comp );
            return getTimer() - start;
        }
    }
}

class TestObject {
    public var value:Number;
}

import flash.display.Sprite;
import flash.display.Stage;
import flash.text.TextField;
import flash.text.TextFormat;


//global trace function
var trace:Function;

//wtreace class
class WTrace
{
        private static var FONT:String = "Fixedsys";
        private static var SIZE:Number = 12;
        

        private static var TextFields:Array = [];
        private static var trace_stage:Stage;
        
        public static function initTrace(stg:Stage):void
        {
            trace_stage = stg;
            trace = wtrace;
        }
        
        private static function scrollup():void
        {
            // maximum number of lines: 100
            if (TextFields.length > 100) 
            {
                var removeme:TextField = TextFields.shift();
                trace_stage.removeChild(removeme);
                removeme = null;
            }
            for(var x:Number=0;x<TextFields.length;x++)
            {
                (TextFields[x] as TextField).y -= SIZE*1.2;
            }
        }
    
        public static function wtrace(... args):void
        {
        
            var s:String="";
            var tracefield:TextField;
            
            for (var i:int;i < args.length;i++)
            {
                // imitating flash:
                // putting a space between the parameters
                if (i != 0) s+=" ";
                s+=args[i].toString();
            }
            

            tracefield= new TextField();
            tracefield.autoSize = "left";
            tracefield.text = s;
            tracefield.y = trace_stage.stageHeight - 20;

            var tf:TextFormat = new TextFormat(FONT, SIZE);
            
            tracefield.setTextFormat(tf);
            

            trace_stage.addChild(tracefield);

            scrollup();                      
            TextFields.push(tracefield);
            
        }
    
}




