/**
 * Copyright kaikoga ( http://wonderfl.net/user/kaikoga )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pNI3
 */

// forked from kaikoga's Objectを使うのとinterfaceを使うのとどっちが速いか検証用
// forked from tail_y's forked from: [最適化 Tips] Number, int, uint の計算による処理速度の違い
// forked from muta244's [最適化 Tips] Number, int, uint の計算による処理速度の違い

package {

import flash.display.*;
import flash.geom.*;
import flash.events.*;
import flash.text.*;
import flash.utils.*;

public class Main extends Sprite
{
    static private const _NUM_TIMES:int = 1000000;
    
    private function _init():void
    {
        _debug(
            "各テスト " + _NUM_TIMES + " 回処理させた計算結果 [単位 ： ミリ秒]\n" +
            "(誤差は多少生じます)"
        );
                
        
        _measure("ループのみ", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                
            }
        });
        
        _measure("Object.undefined", function ():void
        {
            var obj:Object = {};
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:int = obj.y;
            }
        });
        
        _measure("Object[hash]", function ():void
        {
            var obj:Object = {y:1};
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:int = obj["y"];
            }
        });
        
        _measure("Object.hash", function ():void
        {
            var obj:Object = {y:1};
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:int = obj.y;
            }
        });
        
        _measure("dynamic.undefined", function ():void
        {
            var obj:Dynamic = new Dynamic();
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:int = obj.y;
            }
        });
        
        _measure("Object(dynamic).hash", function ():void
        {
            var obj:Object = new Dynamic();
            obj.y = 1;
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:int = obj.y;
            }
        });
        
        _measure("dynamic[hash]", function ():void
        {
            var obj:Dynamic = new Dynamic();
            obj.y = 1;
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:int = obj["y"];
            }
        });
        
        _measure("dynamic.hash", function ():void
        {
            var obj:Dynamic = new Dynamic();
            obj.y = 1;
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:int = obj.y;
            }
        });
        
        _measure("Object(dynamic).defined", function ():void
        {
            var obj:Object = new Dynamic();
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:int = obj.x;
            }
        });
        
        _measure("dynamic[defined]", function ():void
        {
            var obj:Dynamic = new Dynamic();
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:int = obj["x"];
            }
        });
        
        _measure("dynamic.defined", function ():void
        {
            var obj:Dynamic = new Dynamic();
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:int = obj.x;
            }
        });
        
        _measure("Object(proxy).undefined", function ():void
        {
            var obj:Object = new Proxy1();
            obj.y = 1;
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:int = obj.y;
            }
        });
        
        _measure("proxy[undefined]", function ():void
        {
            var obj:Proxy1 = new Proxy1();
            obj.y = 1;
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:int = obj["y"];
            }
        });
        
        _measure("proxy.undefined", function ():void
        {
            var obj:Proxy1 = new Proxy1();
            obj.y = 1;
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:int = obj.y;
            }
        });
        
        _measure("Object(proxy).defined", function ():void
        {
            var obj:Proxy1 = new Proxy1();
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:int = obj.x;
            }
        });
        
        _measure("proxy[defined]", function ():void
        {
            var obj:Proxy1 = new Proxy1();
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:int = obj["x"];
            }
        });
        
        _measure("proxy.defined", function ():void
        {
            var obj:Proxy1 = new Proxy1();
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:int = obj.x;
            }
        });
        
        _measure("Object(sealed).defined", function ():void
        {
            var obj:Object = new Sealed();
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:int = obj.x;
            }
        });
        
        _measure("sealed[defined]", function ():void
        {
            var obj:Sealed = new Sealed();
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:int = obj["x"];
            }
        });
        
        _measure("sealed.defined", function ():void
        {
            var obj:Sealed = new Sealed();
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:int = obj.x;
            }
        });
        
        _measure("Sealed(sealed).defined", function ():void
        {
            var obj:Object = new Sealed();
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:int = Sealed(obj).x;
            }
        });
        
        _measure("sealed[getter]", function ():void
        {
            var obj:Sealed = new Sealed();
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:int = obj["x"];
            }
        });
        
        _measure("sealed.getter", function ():void
        {
            var obj:Sealed = new Sealed();
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:int = obj.getter;
            }
        });
        
        _measure("Sealed(sealed).getter", function ():void
        {
            var obj:Object = new Sealed();
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:int = Sealed(obj).getter;
            }
        });
        
        _measure("(sealed as Sealed).getter", function ():void
        {
            var obj:Object = new Sealed();
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:int = (obj as Sealed).getter;
            }
        });
        
        _measure("interface.getter", function ():void
        {
            var obj:Interface = new Sealed();
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:int = obj.getter;
            }
        });
        
        _measure("Interface(interface).getter", function ():void
        {
            var obj:Object = new Sealed();
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:int = Interface(obj).getter;
            }
        });
        
        _measure("(interface as Interface).getter", function ():void
        {
            var obj:Object = new Sealed();
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:int = (obj as Interface).getter;
            }
        });
        
        _debug("\n結果を説明するスペースなんてなかった");
    }
    
    private var _field:TextField;
    private var _time:uint;
    
    public function Main():void
    {
        _setup();
        _init();
    }
    
    private function _measure(title:String, func:Function, ...params):void
    {
        _time = getTimer();
        func.apply(this, params);
        _time = getTimer() - _time;

        _debug("[ " + title + " ] --> " + _time + " ms");
    }
    
    private function _debug(log:String):void
    {
        _field.appendText(log + "\n");
    }
    
    private function _setup():void
    {
        _field = new TextField();
        _field.width = stage.stageWidth - 40;
        _field.height = stage.stageHeight - 60;
        _field.x = 20;
        _field.y = 60;
        _field.multiline = true;
        _field.wordWrap = true;
        
        var format:TextFormat = _field.defaultTextFormat;
        format.font = "_sans";
        _field.defaultTextFormat = format;
        
        addChild(_field);
        
        var button:Sprite = new Sprite();
        button.graphics.lineStyle(1, 0xBBBBBB);
        button.graphics.beginFill(0xEEEEEE);
        button.graphics.drawRoundRect(0, 0, 100, 20, 5, 5);
        button.graphics.endFill();
        
        addChild(button);
        
        button.x = 20;
        button.y = 20;
        button.mouseChildren = false;
        button.buttonMode = true;
        
        var field:TextField = new TextField();
        field.width = 100;
        field.height = 20;
        field.htmlText = "<p align='center'><font face='_sans'>再計算</span></p>";
        
        button.addChild(field);
        
        button.addEventListener(MouseEvent.CLICK, function ():void
        {
            _field.text = "";
            _init();
        });
    }
}

}

dynamic class Dynamic implements Interface {
    public var x:int = 1;
    public function get getter():int { return this.x; }
}

class Sealed implements Interface {
    public var x:int = 1;
    public function get getter():int { return this.x; }
}

class Sealed2 implements Interface, Interface2, Interface3, Interface4, Interface5, Interface6, Interface7, Interface8 {
    public var x:int = 1;
    public function get getter():int { return this.x; }
}

import flash.utils.Proxy;
import flash.utils.flash_proxy;
dynamic class Proxy1 extends Proxy {
    public var x:int = 1;
    public function get getter():int { return this.x; }
    override flash_proxy function getProperty(name:*):* {
        return undefined;
    }
    override flash_proxy function setProperty(name:*, value:*):void {
        //discard
    }
}

interface Interface {
    function get getter():int;
}

interface Interface2 { }
interface Interface3 { }
interface Interface4 { }
interface Interface5 { }
interface Interface6 { }
interface Interface7 { }
interface Interface8 { }
