/**
 * Copyright saruzaru ( http://wonderfl.net/user/saruzaru )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pMqC
 */

package {
    import flash.events.*;
    import flash.display.*;
    import flash.filters.*;
    import flash.geom.*;
    
    [SWF(frameRate="60", backgroundColor="#000000")]
   
    public class SunflowerSpiral extends Sprite {  
        
        private var blur:BlurFilter;
        private var container:Sprite;
        private var source:Sprite;
        private var bmpd:BitmapData;
        private var matrix:Array;
        private var trans:ColorMatrixFilter = new ColorMatrixFilter(matrix);
        private var ct:ColorTransform = new ColorTransform(1,.9,1,0.95,0,0,0,0);

        private var divergenceOffset:Number;
        private var allColors:Array = ["FF3D11","FE3D11","FD3E12","FD3E12","FC3E13","FC3E13","FB3F14","FB3F14","FA3F15","FA3F15","F94016","F94016","F84017","F84017","F74118","F74118","F64219","F64219","F5421A","F5421A","F4431B","F4431B","F3431C","F3431C","F2441D","F2441D","F1441E","F1441E","F1451F","F1451F","F0451F","F0451F","EF4620","EF4620","EE4721","EE4721","ED4722","ED4722","EC4823","EC4823","EB4824","EB4824","EA4925","EA4925","E94926","E94926","E84A27","E84A27","E74B28","E74B28","E64B29","E64B29","E54C2A","E54C2A","E44C2B","E44C2B","E34D2C","E34D2C","E34D2D","E34D2D","E24E2D","E24E2D","E14E2E","E14E2E","E04F2F","E04F2F","DF5030","DF5030","DE5031","DE5031","DD5132","DD5132","DC5133","DC5133","DB5234","DB5234","DA5235","DA5235","D95336","D95336","D85337","D85337","D75438","D75438","D65539","D65539","D5553A","D5553A","D5563B","D5563B","D4563B","D4563B","D3573C","D3573C","D2573D","D2573D","D1583E","D1583E","D0593F","D0593F","CF5940","CF5940","CE5A41","CE5A41","CD5A42","CD5A42","CC5B43","CC5B43","CB5B44","CB5B44","CA5C45","CA5C45","C95C46","C95C46","C85D47","C85D47","C75E48","C75E48","C75E49","C75E49","C65F49","C65F49","C55F4A","C55F4A","C4604B","C4604B","C3604C","C3604C","C2614D","C2614D","C1624E","C1624E","C0624F","C0624F","BF6350","BF6350","BE6351","BE6351","BD6452","BD6452","BC6453","BC6453","BB6554","BB6554","BA6555","BA6555","B96656","B96656","B86757","B86757","B86757","B86757","B76858","B76858","B66859","B66859","B5695A","B5695A","B4695B","B4695B","B36A5C","B36A5C","B26A5D","B26A5D","B16B5E","B16B5E","B06C5F","B06C5F","AF6C60","AF6C60","AE6D61","AE6D61","AD6D62","AD6D62","AC6E63","AC6E63","AB6E64","AB6E64","AA6F65","AA6F65","AA7065","AA7065","A97066","A97066","A87167","A87167","A77168","A77168","A67269","A67269","A5726A","A5726A","A4736B","A4736B","A3736C","A3736C","A2746D","A2746D","A1756E","A1756E","A0756F","A0756F","9F7670","9F7670","9E7671","9E7671","9D7772","9D7772","9D7773","9D7773","9C7873","9C7873","9B7974","9B7974","9A7975","9A7975","997A76","997A76","987A77","987A77","977B78","977B78","967B79","967B79","957C7A","957C7A","947C7B","947C7B","937D7C","937D7C","927E7D","927E7D","917E7E","917E7E","907F7F","907F7F","8F7F80","8F7F80","8F8081","8F8081","8E8081","8E8081","8D8182","8D8182","8C8183","8C8183","8B8284","8B8284","8A8385","8A8385","898386","898386","888487","888487","878488","878488","868589","868589","85858A","85858A","84868B","84868B","83878C","83878C","82878D","82878D","81888E","81888E","81888F","81888F","80898F","80898F","7F8990","7F8990","7E8A91","7E8A91","7D8A92","7D8A92","7C8B93","7C8B93","7B8C94","7B8C94","7A8C95","7A8C95","798D96","798D96","788D97","788D97","778E98","778E98","768E99","768E99","758F9A","758F9A","748F9B","748F9B","73909C","73909C","73919D","73919D","72919D","72919D","71929E","71929E","70929F","70929F","6F93A0","6F93A0","6E93A1","6E93A1","6D94A2","6D94A2","6C95A3","6C95A3","6B95A4","6B95A4","6A96A5","6A96A5","6996A6","6996A6","6897A7","6897A7","6797A8","6797A8","6698A9","6698A9","6598AA","6598AA","6499AB","6499AB","649AAB","649AAB","639AAC","639AAC","629BAD","629BAD","619BAE","619BAE","609CAF","609CAF","5F9CB0","5F9CB0","5E9DB1","5E9DB1","5D9EB2","5D9EB2","5C9EB3","5C9EB3","5B9FB4","5B9FB4","5A9FB5","5A9FB5","59A0B6","59A0B6","58A0B7","58A0B7","57A1B8","57A1B8","56A1B9","56A1B9","56A2B9","56A2B9","55A3BA","55A3BA","54A3BB","54A3BB","53A4BC","53A4BC","52A4BD","52A4BD","51A5BE","51A5BE","50A5BF","50A5BF","4FA6C0","4FA6C0","4EA6C1","4EA6C1","4DA7C2","4EA6C1","4CA8C3","4CA8C3","4BA8C4","4BA8C4","4AA9C5","4AA9C5","49A9C6","49A9C6","49AAC7","49AAC7","48AAC7","48AAC7","47ABC8","47ABC8","46ACC9","46ACC9","45ACCA","45ACCA","44ADCB","44ADCB","43ADCC","43ADCC","42AECD","42AECD","41AECE","41AECE","40AFCF","40AFCF","3FAFD0","3FAFD0","3EB0D1","3EB0D1","3DB1D2","3DB1D2","3CB1D3","3CB1D3","3BB2D4","3BB2D4","3BB2D5","3BB2D5","3AB3D5","3AB3D5","39B3D6","39B3D6","38B4D7","38B4D7","37B5D8","37B5D8","36B5D9","36B5D9","35B6DA","35B6DA","34B6DB","34B6DB","33B7DC","33B7DC","32B7DD","32B7DD","31B8DE","31B8DE","30B8DF","30B8DF","2FB9E0","2FB9E0","2EBAE1","2EBAE1","2DBAE2","2DBAE2","2DBBE3","2DBBE3","2CBBE3","2CBBE3","2BBCE4","2BBCE4","2ABCE5","2ABCE5","29BDE6","29BDE6","28BDE7","28BDE7","27BEE8","27BEE8","26BFE9","26BFE9","25BFEA","25BFEA","24C0EB","24C0EB","23C0EC","23C0EC","22C1ED","22C1ED","21C1EE","21C1EE","20C2EF","20C2EF","1FC3F0","1FC3F0","1FC3F1","1FC3F1","1EC4F1","1EC4F1","1DC4F2","1DC4F2","1CC5F3","1CC5F3","1BC5F4","1BC5F4","1AC6F5","1AC6F5","19C6F6","19C6F6","18C7F7","18C7F7","17C8F8","17C8F8","16C8F9","16C8F9","15C9FA","15C9FA","14C9FB","14C9FB","13CAFC","13CAFC","12CAFD","12CAFD","11CBFE","11CBFE","11CCFF","11CCFF","11CCFF","11CCFF","FF0000","FF0000","FF0000","FF0000","FF0000","FF0000","FF0000","FF0000","FF0000","FF0000","FF0000","FF0000","FF0000"];

        public function SunflowerSpiral() 
        {
            divergenceOffset = 0;
            init();
            stage.addEventListener( Event.ENTER_FRAME, render );
        }
        
        private function init():void
        {
            trace(stage.stageWidth)
            
            blur = new BlurFilter(5,5,1);            
            bmpd = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x00000000); 
            matrix = new Array();
            matrix = matrix.concat([1, 0, 0, 0, 0]);
            matrix = matrix.concat([0, 1, 0, 0, 0]);
            matrix = matrix.concat([0, 0, 1, 0, 0]);
            matrix = matrix.concat([0, 0, 0, 1, -50]); 
           
            container = new Sprite();
            source = new Sprite();

            addChild(new Bitmap(bmpd));
            addChild(container);                   
        }
        
        private function render( event:Event ):void
        {
            graphics.clear()    
            renderSpiral( 511, 5, 3, divergenceOffset);
            bmpd.draw(this, null, null, BlendMode.NORMAL);
            bmpd.applyFilter(bmpd, bmpd.rect, new Point(), blur);
            bmpd.colorTransform(bmpd.rect,ct);
            divergenceOffset += 0.0023;
        }
        private function renderSpiral( count:int, radius:int, padding:int, offset:Number = 0 ):void
        {
                   
        
            var x:Number = 235;
            var y:Number = 235; 
            
            //offset = stage.mouseX/100
            var divergence:Number = (137.50776 + offset ) / 180 * Math.PI;
            
            for ( var i:int = 1; i <= count; i++ )
            {
                var r:Number = (radius + padding) * Math.sqrt( i ) - radius * 0.3;
                var a:Number = divergence * i;
                var color:String = "0x" + allColors[i];
                var lineColor:String = "0x" + allColors[i + 13];
                
                graphics.lineStyle(2,uint(lineColor)); 
                graphics.beginFill(uint(color));
                graphics.drawCircle( x + Math.cos( a ) * r, y + Math.sin( a ) * r, radius)
                graphics.endFill();
             }
            
           
        }

    }
}