/**
 * Copyright fakestar0826 ( http://wonderfl.net/user/fakestar0826 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pMhT
 */

// forked from fakestar0826's MultiSegmentReach
// forked from fakestar0826's ReachingSegment
// forked from fakestar0826's SingleSegment
package {
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.geom.Point;

    public class PlayBall extends Sprite
    {
        private var segments:Array;
        private var numSegments:uint = 12;
        private var gravity:Number = 0.5;
        private var bounce:Number = -0.9;
        private var ball:Ball;
        
        public function PlayBall()
        {
            init();
        }
        
        private function init():void
        {
            ball = new Ball(20);
            ball.vx = 10;
            addChild(ball);
            segments = new Array();
            for(var i:uint = 0; i < numSegments; i++)
            {
                var segment:Segment = new Segment(25, 20);
                addChild(segment);
                segments.push(segment);
            }
            segment.x = stage.stageWidth / 2;
            segment.y = stage.stageHeight;
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(event:Event):void
        {
            moveBall();
            var target:Point = reach(segments[0], ball.x, ball.y);
            for(var i:uint = 1; i < numSegments; i++)
            {
                var segment:Segment = segments[i];
                target = reach(segment, target.x, target.y);
            }
            for(i = numSegments - 1; i > 0; i--)
            {
                var segmentA:Segment = segments[i];
                var segmentB:Segment = segments[i - 1];
                position(segmentB, segmentA);
            }
            checkHit();
        }
        
        private function reach(segment:Segment, xpos:Number, ypos:Number):Point
        {
            var dx:Number = xpos - segment.x;
            var dy:Number = ypos - segment.y;
            var angle:Number = Math.atan2(dy, dx);
            segment.rotation = angle * 180 / Math.PI;
            
            var w:Number = segment.getPin().x - segment.x;
            var h:Number = segment.getPin().y - segment.y;
            var tx:Number = xpos - w;
            var ty:Number = ypos - h;
            return new Point(tx, ty);
        }
        
        private function position(segmentA:Segment, segmentB:Segment):void
        {
            segmentA.x = segmentB.getPin().x;
            segmentA.y = segmentB.getPin().y;
        }

        private function moveBall():void
        {
            ball.vy += gravity;
            ball.x += ball.vx;
            ball.y += ball.vy;
            if(ball.x + ball.r > stage.stageWidth)
            {
                ball.x = stage.stageWidth - ball.r;
                ball.vx *= bounce;
            }
            else if(ball.x - ball.r < 0)
            {
                ball.x = ball.r;
                ball.vx *= bounce;
            }
            if(ball.y + ball.r > stage.stageHeight)
            {
                ball.y = stage.stageHeight - ball.r;
                ball.vy *= bounce;
            }
            else if(ball.y - ball.r < 0)
            {
                ball.y = ball.r;
                ball.vy *= bounce;
            }
        }
        
        public function checkHit():void
        {
            var segment:Segment = segments[0];
            var dx:Number = segment.getPin().x - ball.x;
            var dy:Number = segment.getPin().y - ball.y;
            var dist:Number = Math.sqrt(dx * dx + dy * dy);
            if(dist < ball.r)
            {
                ball.vx += Math.random() * 2 - 1;
                ball.vy -= 1;
            }
        }
    }
}
import flash.geom.Point;
import flash.display.Sprite;

class Segment extends Sprite
{
    private var color:uint;
    private var segmentWidth:Number;
    private var segmentHeight:Number;
    
    public var vx:Number = 0;
    public var vy:Number = 0;
    
    public function Segment(segmentWidth:Number, segmentHeight:Number, color:uint = 0xFFFFFF)
    {
        this.segmentWidth = segmentWidth;
        this.segmentHeight = segmentHeight;
        this.color = color;
        
        graphics.lineStyle(0);
        graphics.beginFill(color);
        graphics.drawRoundRect(-segmentHeight / 2, -segmentHeight / 2, segmentWidth + segmentHeight, segmentHeight, segmentHeight, segmentHeight);
        graphics.endFill();
        
        graphics.drawCircle(0, 0, 2);
        graphics.drawCircle(segmentWidth, 0, 2);
    }
    
    public function getPin():Point
    {
        var angle:Number = rotation * Math.PI / 180;
        var xPos:Number = x + Math.cos(angle) * segmentWidth;
        var yPos:Number = y + Math.sin(angle) * segmentWidth;
        
        return new Point(xPos, yPos);
    }


}

class Ball extends Sprite
{
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var r:Number;
    
    public function Ball(r:Number = 30, c:uint = 0xFF0000)
    {
        this.r = r;
        this.graphics.beginFill(c);
        this.graphics.drawCircle(0, 0, r);
        this.graphics.endFill();
    }

}
