/**
 * Copyright faseer ( http://wonderfl.net/user/faseer )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pMeZ
 */

package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Point;
	

	public class Main extends Sprite 
	{
		
		private const _dot:Dot = create( 10 );
		
		private const _bgDot:Dot = create( 800 );
		
		private const _ct:ColorTransform = new ColorTransform(0.955, 0.965, 0.985);
		private const _origin:Point = new Point(0, 0);
		private const _blur:BlurFilter = new BlurFilter(4.0, 4.0);
		
		
		private var _line:Shape;
		private var _bg:Bitmap;
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, onAddedToStage);
		}
		
		private function onAddedToStage(e:Event):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, onAddedToStage);
			init();
		}
		
		private function init():void
		{
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.stageFocusRect = false;
			
			//__________________________________________________init curve
			var length:Number = stage.stageWidth;
			var num:Number = 10;
			var gap:Number = length / num;
			
			var d:Dot = _dot;
			while (d && d.next)
			{
				d.next.x = d.x + gap;
				d = d.next;
			}
			
			_dot.vy = 10;
			
			//__________________________________________________init background
			d = _bgDot;
			while (d)
			{
				d.x = Math.random() * stage.stageWidth;
				d.y = Math.random() * stage.stageHeight;
				d.ay = Math.random();
				d = d.next;
			}
			
			//__________________________________________________init assets
			_bg = new Bitmap(); addChild(_bg);
			_line = new Shape();  addChild(_line);
			
			_line.x = 50;
			_line.y = 120;
			_bg.bitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x000000);
			
			
			addEventListener(Event.ENTER_FRAME, execute);
		}
		
		private function execute(e:Event):void 
		{
			_line.graphics.clear();
			_line.graphics.lineStyle(2, 0x888888);
			
			
			var d:Dot = _dot;
			var p:Dot = d;
			
			_line.graphics.moveTo(d.x, d.y);
			
			while (d)
			{
				if(d!=p) d.vy = -(d.y - p.y) * 0.11;
				
				d.ay = -d.y / 100;
				d.vy += d.ay;
				d.y += d.vy;
				
				if(d.next)
					_line.graphics.curveTo(d.x, d.y, (d.x + d.next.x) * .5, (d.y + d.next.y) * .5);
				
				p = d;
				d = d.next;
			}
			
			
			//__________________________________________________render background
			var w:Number = stage.stageWidth;
			var bd:BitmapData = _bg.bitmapData;
			
			
			bd.draw(bd, null, _ct);
			bd.applyFilter(bd, bd.rect, _origin, _blur);
			
			bd.lock();
			
			d = _bgDot;
			while (d)
			{
				if (d.x < 0) { d.x = Math.random() * w; d.vx = 0; }
				else if (d.x > w) { d.x = 0; d.vx = 0; }
				
				d.vx += d.ay;
				d.x += d.vx;
				
				bd.setPixel(d.x, d.y, 0xFFFFFF);
				
				d = d.next;
			}
			
			bd.unlock();
			
			
		}
		
		private function create( num:int ):Dot
		{
			if (num < 1) return null;
			
			const start:Dot = new Dot();
			var current:Dot = start;
			
			while (--num > 0)
			{
				current = current.next = new Dot();
			}
			
			return start;
		}
		
	}
	
}

 class Dot
	{
		public var x:Number = 0.0;
		public var y:Number = 0.0;
		public var vx:Number = 0.0;
		public var vy:Number = 0.0;
		public var ay:Number = 0.0;
		
		public var next:Dot;
		
	}