/**
 * Copyright jancassio ( http://wonderfl.net/user/jancassio )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pMbH
 */

package {
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    import flash.geom.Point;
    import flash.text.TextField;
    import flash.events.Event;
    import flash.display.Sprite;
    
    [SWF(frameRate="60", backgroundColor="#000")]
    public class FlashTest extends Sprite {
        
        protected var _console:TextField;
        protected var _squares:Vector.<Square>;
        protected var _timer:Timer
        
        public function FlashTest() {
            _console = new TextField;
            _console.textColor = 0xFFFFFF;
            _console.width = 400;
            _console.wordWrap = true;
            _console.multiline = true;
            _console.mouseEnabled = false;
            addChild(_console);
            conf();
        }
        
        protected function conf () : void
        {
            log("Conf");
            (stage) ? init() : addEventListener(Event.ADDED_TO_STAGE, onAddedToStage);
        }
        
        protected function init () : void
        {
            _squares = new <Square>[];
            _timer = new Timer(1000);
            makeSquares();
            addEventListener(Event.EXIT_FRAME, onEnterFrame);
            _timer.addEventListener(TimerEvent.TIMER, onTimerTick);
            _timer.start();
        }

        
        protected function makeSquares () : void
        {
            var s : Square;
            var i : int;
            var c : int;
            
            c = 100;
            
            for(; i < c; i++)
            {
                s = new Square;
                
                s.point = new Point(Math.random() * stage.stageWidth, Math.random() * stage.stageHeight);
                addChild( s );
                
                _squares[ _squares.length ] = s;
            }
        }
        
        protected function onEnterFrame (event:Event) : void
        {
            var s : Square;
            var i : int;
            var l : int;
            
            l = _squares.length;
            
            for(; i < l; i++)
                _squares[ i ].render();
                
        }
        
        protected function onTimerTick(event:Event):void
        {
            var s : Square;
            var i : int;
            var l : int;
            
            l = _squares.length;
            
            for(; i < l; i++)
            {
                s = _squares[i];
                
                s.point = new Point(Math.random() * stage.stageWidth, Math.random() * stage.stageHeight);
            }
        }

        
        protected function onAddedToStage(event:Event) : void
        {
            removeEventListener(Event.ADDED_TO_STAGE, onAddedToStage);
            init();
        }


        protected function log(message : String) : void
        {
            _console.appendText("[" + (new Date).toString().split(" ")[3] + "]: " + message + "\n");
        }


        
        
    }
}
import flash.geom.Point;
import flash.display.Sprite;


class Square extends Sprite
{
    protected var _point : Point;
    protected const BREAK:int = 4;
    
    public function Square ()
    {
        graphics.beginFill(0xFF0000);
        graphics.drawRect(0, 0, 10, 10);
        graphics.endFill();
    }
    
    public function set point (value : Point) : void
    {
        _point = value;
    }
    
    public function render () : void
    {
        x += (_point.x - x) >> BREAK;
        y += (_point.y - y) >> BREAK;
    }
}
