/**
 * Copyright www0z0k ( http://wonderfl.net/user/www0z0k )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pMG9
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    
    /**
     *
     * @author www0z0k
     */
    public class Main extends Sprite {
        private var canSG:Base;
        public function Main():void {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            canSG = new Base();
            addChild(canSG);
            canSG.x = 100;
            canSG.y = 250;
            canSG.start();
        }        
    }    
}    

    import flash.display.Sprite;
    import flash.events.Event;
    class Base extends Sprite{
        private var counter:int = 0;
        private const PERIOD:int = 12;
        public function Base() {
            
        }
        
        public function start():void {            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void {
            if (numChildren > 1) {
                var ss:SmokeySphere = (getChildAt(numChildren - 2) as SmokeySphere).clone();
                addChild(ss);
                ss.updateFrom((getChildAt(numChildren - 2) as SmokeySphere));
            }
            if (counter % PERIOD == 0) {
                addChild(new SmokeySphere());
            }
            counter++;
            var arr:Array = new Array();
            for (var i:int = 0; i < numChildren; i++) {
                if (!(getChildAt(i) as SmokeySphere).float()) {
                    arr.push(i);
                }
            }
            for (var c:int = 0; c < arr.length; c++) {
                removeChildAt(arr[c]);
            }
        }
        
    }    
    
    
    import flash.display.Shape;
    import flash.filters.BlurFilter;
    class SmokeySphere extends Shape{
        
        public function SmokeySphere() {
            draw();
        }
        
        private function draw():void{
            graphics.beginFill(0x666666, 0.5);
            graphics.drawCircle(0, 0, 4);
            graphics.endFill();
            filters.push(new BlurFilter(7, 7, 2));            
        }
        
        public function float():Boolean {
            y -= Math.floor(Math.random() * 3);
            x += 1 - Math.floor(Math.random() * 3);
            scaleX += 0.01;
            scaleY += 0.01;
            alpha -= 0.0075;
            return alpha > 0;
        }
        
        public function clone():SmokeySphere {
            var ss:SmokeySphere = new SmokeySphere();
            ss.x = x;
            ss.y = y;
            ss.scaleX = scaleX;
            ss.scaleY = scaleY;
            ss.alpha = alpha;
            return ss;
        }
        
        public function updateFrom(ss:SmokeySphere):void {
            y = ss.y - 3;
            x = ss.x + 1 - Math.floor(Math.random() * 3);
            scaleX = ss.scaleX + 0.05;
            scaleY = ss.scaleY + 0.05;
            alpha = ss.alpha - 0.01;
        }
        
    }
