/**
 * Copyright jozefchutka ( http://wonderfl.net/user/jozefchutka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pM4Z
 */

package
{
    import flash.display.DisplayObject;
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.IOErrorEvent;
    import flash.events.SecurityErrorEvent;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import flash.net.URLVariables;
    import flash.system.ApplicationDomain;
    import flash.system.LoaderContext;
    import flash.system.Security;
    
    public class ApplicationLoaderWeb extends Sprite
    {
        private var serverRoot:String;
        
        private var _gameFlashvars:Object;
        private var _game:DisplayObject;
        
        public function ApplicationLoaderWeb()
        {
            super();
            
            serverRoot = "http://trainlord.com";
            
            Security.allowDomain("*");
            
            if(stage)
            {
                initStage();
                loadGameFlashvars();
            }
            else
            {
                addEventListener(Event.ADDED_TO_STAGE, onAddedToStage, false, 0, true);
            }
        }
        
        protected function get flashvars():Object
        {
            return loaderInfo.parameters;
        }
        
        protected function get gameFlashvars():Object
        {
            return _gameFlashvars;
        }
        
        protected function get game():DisplayObject
        {
            return _game;
        }
        
        protected function initStage():void
        {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.frameRate = 60;
            stage.addEventListener(Event.RESIZE, onStageResize);
        }
        
        protected function init():void
        {
            loadGame();
        }
        
        protected function loadGame():void
        {
            var variables:URLVariables = new URLVariables;
            for(var key:String in gameFlashvars)
                variables[key] = gameFlashvars[key];
            
            var request:URLRequest = new URLRequest;
            request.url = serverRoot + "/" + gameFlashvars.swfFile;
            request.data = variables;
            
            var context:LoaderContext = new LoaderContext;
            context.applicationDomain = new ApplicationDomain(ApplicationDomain.currentDomain);
            
            var loader:Loader = new Loader;
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onGameLoaderInfoComplete);
            loader.load(request);
        }
        
        protected function resizeGame():void
        {
            if(!game)
                return;
            
            var gameObject:Object = game;
            if(!gameObject.hasOwnProperty('setActualSize'))
                return;
            
            try
            {
                gameObject.setActualSize(stage.stageWidth, stage.stageHeight);
            }
            catch(error:Error)
            {
                trace(error);
            }
        }
        
        private function loadGameFlashvars():void
        {
            var request:URLRequest = new URLRequest;
            request.url = serverRoot + "/flashvars.js";
            
            var loader:URLLoader = new URLLoader;
            loader.addEventListener(Event.COMPLETE, onGameFlashvarsLoaderComplete);
            loader.addEventListener(IOErrorEvent.IO_ERROR, onGameFlashvarsLoaderIOError);
            loader.addEventListener(SecurityErrorEvent.SECURITY_ERROR, onGameFlashvarsLoaderSecurityError);
            loader.load(request);
        }
        
        private function onAddedToStage(event:Event):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, onAddedToStage, false);
            
            initStage();
            loadGameFlashvars();
        }
        
        private function onGameFlashvarsLoaderComplete(event:Event):void
        {
            var loader:URLLoader = event.currentTarget as URLLoader;
            _gameFlashvars = JSON.parse(loader.data);
            init();
        }
        
        private function onGameFlashvarsLoaderIOError(event:IOErrorEvent):void
        {
            trace(event);
        }
        
        private function onGameFlashvarsLoaderSecurityError(event:SecurityErrorEvent):void
        {
            trace(event);
        }
        
        private function onGameLoaderInfoComplete(event:Event):void
        {
            var loaderInfo:LoaderInfo = event.currentTarget as LoaderInfo;
            _game = loaderInfo.content;
            addChild(game);
            resizeGame();
        }
        
        private function onStageResize(event:Event):void
        {
            resizeGame();
        }
    }
}