/**
 * Copyright wwbeyondww1 ( http://wonderfl.net/user/wwbeyondww1 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pLEF
 */

// forked from mousepancyo's フツーの花火
/*
夏が終わりそうなので終わる前に花火。
コードは…
いろいろ考えてみましたが、凡人の僕では
気の利いたことは何一つできませんでした…
*/

package{
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    
    [SWF(width = "465", height = "465", backgroundColor = "0x000613", frameRate = "24")]
    
    public class Main extends Sprite{
        
        private static const W:Number = 465;
        private static const H:Number = 465;
        private static const FREQUENCY_RANGE:int = 14
        private static const GLOW_RANGE:int = 3
        
        private var _particles:Vector.<Particle> = new Vector.<Particle>();
        private var _canvas:BitmapData;
        private var _glow:BitmapData;
        private var _ct:ColorTransform;
        private var _startX:Number;
        private var _startY:Number;    
        
        public function Main(){
            graphics.beginFill(0x000613)
            graphics.drawRect(0, 0, W, H) 
            //
            setUp()
        }
        
        private function setUp():void{
            _ct = new ColorTransform(0.9, 0.9, 0.9, 0.98);
            _canvas = new BitmapData(W, H, false, 0);
            var canvas:Bitmap = new Bitmap(_canvas, "auto", true);
            canvas.blendMode = "screen";
            _glow = new BitmapData(W / GLOW_RANGE, H / GLOW_RANGE, false, 0);
            var bm:Bitmap = new Bitmap(_glow, "never", true);
            bm.scaleX = bm.scaleY = GLOW_RANGE;
            bm.blendMode = "add";
            //
            addChild(canvas);
            addChild(bm);
            addEventListener(Event.ENTER_FRAME, update);
        }
        
        private function createParticle():void {
            var p:Particle = new Particle();
            var radius:Number = Math.sqrt(Math.random())*10;
            var angle:Number = Math.random() * (Math.PI)*2;
            p.x = _startX;
            p.y = _startY;
            p.vx = Math.cos(angle) * radius;
            p.vy = Math.sin(angle) * radius;
            _particles.push(p);
        }
        
        private function colorChange():void{
            (_ct.redMultiplier > 0.99)? _ct.redMultiplier = 0.9 : _ct.redMultiplier += 0.003;
            (_ct.greenMultiplier > 0.99)? _ct.greenMultiplier = 0.9 : _ct.greenMultiplier += 0.006;
            (_ct.blueMultiplier > 0.99)? _ct.blueMultiplier = 0.9 : _ct.blueMultiplier += 0.009;
        }
        
        private function spark():void{
            var n:int = Math.random() * 100 + 150;
            _startX = Math.random() * (W * 0.6) + (W * 0.2);
            _startY = Math.random() * H / 4 + 100;
            while (n--) createParticle();
        }
        
        private function update(e:Event):void{
            _canvas.lock();
            _canvas.applyFilter(_canvas, _canvas.rect, new Point(), new BlurFilter(2, 4));
            _canvas.colorTransform(_canvas.rect, _ct);
            //
            var n:int = _particles.length;
            while (n--) {
                var v:Number = Math.random() * 0.14 + 0.85;
                var p:Particle = _particles[n];
                p.vy += 0.2;
                p.vx *= v;
                p.vy *= v;
                p.x += p.vx;
                p.y += p.vy;
                _canvas.setPixel(p.x, p.y, p.c);
                //
                if ((p.x > stage.stageWidth || p.x < 0) || (p.y < 0 || p.y > stage.stageHeight) || Math.abs(p.vx) < .01 || Math.abs(p.vy) < .01){
                    _particles.splice(n, 1);
                }
            }
            _canvas.unlock();
            _glow.draw(_canvas, new Matrix(1 / GLOW_RANGE, 0, 0, 1 / GLOW_RANGE));
            //
            colorChange()
            //
            var frequency:Boolean = Boolean(int(Math.random() * FREQUENCY_RANGE))
            if(frequency == false) spark();
        }
    }
}


//
import flash.geom.Point;

class Particle extends Point{
    public var vx:Number = 0
    public var vy:Number = 0
    public var c:uint = 0xFFFFFF;
}