/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pL56
 */

package {
  import com.actionscriptbible.Example;
  import flash.net.SharedObject;
  import flash.net.registerClassAlias;

  public class ch29ex3 extends Example {
    protected var currentPage:int;
    protected var so:SharedObject;
    
    public function ch29ex3() {
      registerClassAlias("Bookmark", Bookmark);
      so = SharedObject.getLocal("storage");
      if (so.data.bookmark) {
        //go to the stored bookmark
        var b:Bookmark = Bookmark(so.data.bookmark);
        trace("found", b);
        gotoPage(b.page);
        
        //read the next page and bookmark it
        trace("advancing a page...");
        gotoPage(currentPage + 1);
        setBookmark();
      } else {
        //start at the first page if there's no bookmark
        gotoPage(1);
        setBookmark();
      }
    }
    
    public function setBookmark():void {
      var b:Bookmark = new Bookmark();
      b.page = currentPage;
      so.data.bookmark = b;
      trace("setting", so.data.bookmark);
    }
    
    public function gotoPage(page:int):void {
      trace("going to page", page);
      currentPage = page;
    }
  }
}

class Bookmark {
  public var page:int;
  
  public function Bookmark() {
  }
  
  public function toString():String {
    return "[Bookmark at page " + page + "]";
  }
}
