/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pKyi
 */

package  
{
	import com.flashdynamix.motion.Tweensy;
	import com.flashdynamix.motion.TweensyTimeline;
	import fl.motion.easing.Sine;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	
	[SWF(width="465", height="465", frameRate="60", backgroundColor="0xFFFFFF")]
	/**
	 * ...
	 * @author tkinjo
	 */
	public class Main extends Sprite
	{
		
		/**
		 * コンストラクタ
		 */
		public function Main() 
		{
			var tweenCounter:TweenCounter = new TweenCounter();
			
			addEventListener(Event.ENTER_FRAME, function( event:Event ):void {
					
					tweenCounter.count();
					textField.text = "" + tweenCounter.counted;
				} );
			tweenCounter.addEventListener( TweenCounter.COUNT_COMPLETE, function( event:Event ):void {
					
					var textFieldTweenTimeLine:TweensyTimeline = Tweensy.fromTo( textField, { y:100 }, { y:90 }, 0.1, Sine.easeOut );
					textFieldTweenTimeLine.repeatType = TweensyTimeline.YOYO;
					textFieldTweenTimeLine.repeats = 1;
				} );
			
			// テキストフィールドの設定
			var textField:TextField = new TextField();
			textField.text = "0";
			textField.x = 100;
			textField.y = 100;
			addChild( textField );
			
			// 背景の設定
			var sprite:Sprite = new Sprite();
			sprite.graphics.beginFill( 0xffffff );
			sprite.graphics.drawRect( 0, 0, stage.stageWidth, stage.stageHeight );
			sprite.graphics.endFill();
			addChild( sprite );
			
			swapChildren( sprite, textField );
			
			addEventListener( MouseEvent.MOUSE_DOWN, function( event:Event ):void {
					tweenCounter.countTo = tweenCounter.countTo + 10;
				} );
		}
	}
	
	
	
}


import com.flashdynamix.motion.Tweensy;
import com.flashdynamix.motion.TweensyTimeline;
import fl.motion.easing.Sine;
import flash.events.Event;
import flash.events.EventDispatcher;

/**
 * ...
 * @author tkinjo
 */
class TweenCounter extends EventDispatcher 
{
	
	/**
	 * カウント修了時に
	 */
	public static const COUNT_COMPLETE:String = "countComplete";
	
	
	
	
	
	/**
	 * tweenCounter が counted に達するまでの時間
	 */
	public var duration:Number;
	
	/**
	 * イージング
	 */
	public var easing:Function;
	
	/**
	 * カウンター
	 */
	public var counted:Number;
	
	/**
	 * 
	 */
	public var tweenCounter:Number;
	
	
	
	// 
	private var tweenCounterTimeLine:TweensyTimeline;
	
	/**
	 * 
	 */
	public function get countTo():Number { return _countTo; }
	
	/**
	 * @private
	 */
	public function set countTo(value:Number):void 
	{
		_countTo = value;
		
		if ( !tweenCounterTimeLine || ( tweenCounterTimeLine && tweenCounterTimeLine.finished ) ) {
			
			tweenCounterTimeLine = Tweensy.to( this, { tweenCounter:_countTo }, duration, easing );
			tweenCounterTimeLine.onComplete = function():void { dispatchEvent( new Event( COUNT_COMPLETE ) ) };
			
		} else {
			
			tweenCounterTimeLine.duration = tweenCounterTimeLine.time + duration;
			tweenCounterTimeLine.updateTo( this, { tweenCounter:_countTo } );
		}
	}
	
	private var _countTo:Number;
	
	
	
	
	
	
	/**
	 * コンストラクタ
	 */
	public function TweenCounter( counted:Number = 0, countTo:Number = 0, duration:Number = 3, easing:Function = null ) 
	{
		this.counted = counted;
		tweenCounter = counted;
		
		this.duration = duration;
		this.easing = easing;
		this.countTo = countTo;
		
		if ( !( easing ) )
			easing = Sine.easeInOut;
	}
	
	/**
	 * カウントする
	 */
	public function count():void {
		
		if ( counted+1 <= tweenCounter ) {
			
			counted++;
		}
	}
}