// Re: http://www.flashsandy.org/forum/viewtopic.php?t=1474
// License: WTFPL v2, http://sam.zoy.org/wtfpl
package {
    import flash.display.Sprite;
    import sandy.core.Scene3D;
    import sandy.core.scenegraph.*;
    import sandy.primitive.*;

    public class PyramidTest extends Sprite {
        private var scene:Scene3D;
        private var camObj:TransformGroup;

        public function PyramidTest () {
            scene = new Scene3D ("test", this,
                new Camera3D (465, 465), new Group);

            var s2:Number = Math.sqrt (2);

            // pyramid dimensions are exact values in meters,
            // pyramid placing is approximate, based on this map:
            // http://en.wikipedia.org/wiki/File:Giza_pyramid_complex_(map).svg

            var cone1:Cone = new Cone ("khufu", 230 / s2, 139, 4, 1);
            scene.root.addChild (cone1); cone1.rotateY = 45;
            cone1.x = 340; cone1.z = 350;

            var cone2:Cone = new Cone ("khafre", 215 / s2, 144, 4, 1);
            scene.root.addChild (cone2); cone2.rotateY = 45;

            var cone3:Cone = new Cone ("menkaure", 108 / s2, 66, 4, 1);
            scene.root.addChild (cone3); cone3.rotateY = 45;
            cone3.x = -240; cone3.z = -260;

            camObj = new TransformGroup ("cam");
            camObj.addChild (scene.camera);
            scene.root.addChild (camObj);
            scene.camera.z = -2000;

            addEventListener ("enterFrame", function ():void {
                camObj.pan++; camObj.tilt++; scene.render ();
            });
        }
    }
}