/**
 * Copyright inosyan ( http://wonderfl.net/user/inosyan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pJsL
 */

package {
    import flash.text.TextField;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        private var _output:TextField;
        public function FlashTest() {
            _output = new TextField;
            _output.width = 400;
            _output.height = 300;
            addChild(_output);
            
            experiment_List_Table();
        }
        
        private function experiment_List_Table():void
        {
            const LOOPCNT:int = 1000;
           
            var rectime:Number, trg:String, ans:int, loop:int;
            
            var s:String = "ArrayのアクセスとObjectのマップ生成との時間比較\n"+
            "結果は画面に収まりきれてないけど、もっと下まであります\n\n";
            for each( var testcnt:int in [1,5,10] ){
                s += "----- 検索する回数が"+testcnt + "回の場合 -----\n";
                for each( var max:int in [1,5,10,30,50,100,300,500] ){
                    s += "///// 要素が"+max + "個の場合 ("+LOOPCNT+"回分加算) /////\n";
                    s += _sub(max,testcnt);
                }
                s += "\n";
            }
            _output.text = s;
            
            function _sub(max:int,testcnt:int):String
            {
                var ret:String = "";
                // Array
                var list:Array = [];
                for( var i:int = 0; i < max; ++i ){
                    var data:* = {name:"name"+i,value:i};
                    list.push(data);
                }
                
                rectime = (new Date).time;
                for( loop = 0; loop < LOOPCNT; ++loop ){
                    for( i = 0; i < testcnt; ++i ){
                        trg = "name"+int(Math.random()*max);
                        for( var j:int = 0; j < list.length; ++j ){
                            if(list[j].name == trg){
                                ans = list[j].value;
                                break;
                            }
                        }
                    }
                }
                ret += "Array " + ((new Date).time - rectime) + "ms\n"; 
                
                // Objectマップを生成する時間
                rectime = (new Date).time;
                for( loop = 0; loop < LOOPCNT; ++loop ){
                    var table:Object = {};
                    for( i = 0; i < list.length; ++i ){
                        data = list[i];
                        table[data.name] = data;
                    }
                    for( i = 0; i < testcnt; ++i ){
                        trg = "name"+int(Math.random()*max);
                        ans = table[trg].value;
                    }
                }
                ret += "Object " + ((new Date).time - rectime) + "ms\n"; 
                return ret;
            }
            
        }
    }
}