/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pJoV
 */

// forked from gaziya's 遠近法のテスト2

package 
{   
    import flash.geom.Matrix3D;
    import flash.display.Shape;
    import flash.events.Event;
    import flash.geom.Vector3D;
    import flash.display.Sprite;
    
    [SWF(width=465,height=465,frameRate=30)]
    
    public class FlashTest extends Sprite 
    {
        public function FlashTest() 
        {
            x = stage.stageWidth/2
            y = stage.stageHeight/2            
            
            var points:Vector.<Vector3D> = new Vector.<Vector3D>
            var container:Sprite= new Sprite
            var shapes:Vector.<Shape> = new Vector.<Shape>
            var length:Number = 300    

            for (var i:int = 0; i < 100; i++)
            {
                var vector:Vector3D = new Vector3D
                (
                    Math.round((Math.random()-0.5)*length),
                    Math.round((Math.random()-0.5)*length),
                    Math.round((Math.random()-0.5)*length)
                )
                points.push(vector)           
                
                var rect_size:int = Math.random()*30 +15
                shapes.push(new Shape)
                shapes[i].graphics.beginFill(Math.random()*0xffff)                
                shapes[i].graphics.drawRect(-rect_size/2, -rect_size/2,rect_size,rect_size)
                shapes[i].x = vector.x
                shapes[i].y = vector.y
                shapes[i].z = vector.z
                shapes[i].rotationX = Math.random()*180
                shapes[i].rotationY = Math.random()*180
                shapes[i].rotationZ = Math.random()*180
                container.addChild(shapes[i])
            }
            addChild(container)   
   
            var theta_x:Number = 0
            var theta_y:Number = 0
            addEventListener(Event.ENTER_FRAME, loop)                                      
            function loop(e:Event):void {
                theta_x += mouseX/50
                theta_x %= 360
                theta_y += mouseY/50
                theta_y %= 360
                var matrix:Matrix3D = new Matrix3D              
                matrix.appendRotation(theta_x,Vector3D.X_AXIS)    
                matrix.appendRotation(theta_y,Vector3D.Y_AXIS)                
                var sort_items:Array = new Array
                for (var i:int=0; i<points.length; i++) {
                    var vector:Vector3D = matrix.transformVector(points[i])
                    vector.w = i
                    sort_items.push(vector)
                    container.removeChild(shapes[i])                    
                }
                sort_items.sortOn("z", Array.NUMERIC | Array.DESCENDING)
                for (var j:int=0; j<points.length; j++) {
                    container.addChild(shapes[sort_items[j].w])
                }                
                container.rotationX = theta_x
                container.rotationY = theta_y                
            }    
        }
    }
}
