/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pJXH
 */

package {
    import flash.text.TextField;
    import flash.utils.Dictionary;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {

           deb = new TextField();
            deb.mouseEnabled = false;
            deb.width = 320;
            deb.height = 240;
          addChild(deb); 

           vecBlob = new Vector.<xBlob>(0, false);
           vecCmd = new Vector.<xCmd>(0, false);

           addCmd("make", 16, 320, 240);
           addCmd("make", 32, 320, 300);
           addCmd("wait", 10);
           addCmd("walkto", 32, 100, 300);
           addCmd("movewait", 32);
           addCmd("setpos",16, 160, 240);
           addCmd("wait", 30);
           addCmd("walkto", 16, 0, 0);
           addCmd("walkto", 32, 430, 230);
           addCmd("movewait", 32);
           addCmd("walkto", 16, 230, 130);
           addCmd("walkto", 32, 230, 330);
           addCmd("wait", 30);
           
           

           stage.addEventListener(Event.ENTER_FRAME, onEnter);             
        }//ctor
        
        public var deb:TextField;
       
        public var dictBlob:Dictionary = new Dictionary();
       
        public var vecBlob:Vector.<xBlob>;
        public var vecCmd:Vector.<xCmd>;
        public var curCmd:int = 0;

        public var curWait:int = 0;
        public var moveWait:int = -1;

        public function addCmd(c:String, a0:int=0,a1:int=0, a2:int =0):xCmd
        {
          var a:xCmd;  a = new xCmd();  vecCmd.push(a);
           a.cmd = c;  a.arg0 = a0; a.arg1 = a1; a.arg2= a2;  
          return a;
        }//addcmd

        public function addBlob(id:int):xBlob
        {
           var a:xBlob;  a = new xBlob();        vecBlob.push(a);
           dictBlob[id] = a;          a.id = id;       return a;
        }//addblob
        
        public function getBlob(id:int):xBlob
        { var a:xBlob; a = dictBlob[id]; return a; }
        
        public function setPos(id:int, ax:Number, ay:Number):void
        { var a:xBlob; a= getBlob(id);if(a==null){return;} a.cx=ax; a.cy=ay; }
        
        public function walkTo(id:int, ax:Number, ay:Number):void
        { var a:xBlob; a= getBlob(id);if(a==null){return;} a.gx=ax; a.gy=ay; a.move = 1; }
        
        public function procCmd(a:xCmd):void
        {
      
          var b:xBlob; var c:String;   c = a.cmd.toLowerCase();
            switch (c)            
            {      
              case "wait":  curWait = a.arg0;  break;
              case "make": b=addBlob(a.arg0); b.cx=a.arg1; b.cy=a.arg2; break;    
              case "setpos": setPos(a.arg0, a.arg1, a.arg2); break;
              case "walkto": walkTo(a.arg0, a.arg1, a.arg2);  break; 
              case "movewait": case "waitmove": moveWait = a.arg0; break;
            }//swend
        }//proccmd
        
        
        public function onEnter(e:Event):void
        {
           graphics.clear();
           graphics.lineStyle(2, 0);            
           
           var i:int; var num:int; var a:xBlob;
           num = vecBlob.length;
           for (i = 0; i < num; i++)
           {
             a = vecBlob[i];
             
             if (a.move > 0)
             {
               var ang:Number;
               ang = Math.atan2(a.gy-a.cy, a.gx-a.cx);
               a.cx += Math.cos(ang)*4;
               a.cy += Math.sin(ang)*4;
               if (getMag(a.cx-a.gx, a.cy-a.gy) < 6) { a.move = 0; }
                 
             }//endif
             
             graphics.drawCircle(a.cx, a.cy, 16);
           }//nexti
           
           
           var c:xCmd;
           for (i = 0; i < 64; i++)
           {
             if (moveWait > 0) {
                 a = getBlob(moveWait); 
                 if (a==null) {moveWait=-1; i=-1; continue; }
                 if (a.move <=0){moveWait=-1; i-=1; continue; }
                 break;  
             }//endif   
             if (curWait > 0) { curWait -= 1;  break; }
             if (curCmd >= vecCmd.length) { break; }
             c = vecCmd[curCmd]; curCmd += 1;
             procCmd(c);               
           }//nexti
           
           deb.text = " "+curCmd + " " + curWait + " " + moveWait;
           
        }//onenter
        
        public function getMag(ax:Number, ay:Number):Number
        { return Math.sqrt(ax*ax+ay*ay); }
        
    }//classend
}

internal class xBlob
{
   public var cx:Number = 0;
   public var cy:Number = 0;
   public var id:int = 0;  
   
   public var gx:Number = 0;
   public var gy:Number = 0;
   public var move:int = 0;
   
}//xblob

internal class xCmd
{
  public var cmd:String = "";
  public var arg0:int = 0;
  public var arg1:int = 0;
  public var arg2:int = 0;
    
}//cmd