/**
 * Copyright shmdmoto ( http://wonderfl.net/user/shmdmoto )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pJH2
 */

// forked from shmdmoto's 曲線を描く
package 
{
    import frocessing.display.F5MovieClip2D;
    /**
     * 曲線を描く
     * @author shmdmoto
     */
    public class GraphicExample extends F5MovieClip2D
    {
        public function setup() : void
        {
            var i:int;
            for( i = 3 ; i < 10 ; i++ ) {
                drawNgon( i * 50 - 100, 100, 30, i);
            }
                stroke(0);
                fill(255,0,0);             
            for( i = 5 ; i < 10 ; i++ ) {
                drawNStar( i * 60 - 200, 300, 30, i);
            }
        }
        // 正n角形を描く
        // x,y : 中心点の座標
        // r : 半径
        // n : 角の数
        private function drawNgon( x:Number, y:Number, 
                    r:Number,n:Number) : void
        {
            var i:int;
            beginShape();
            for( i = 0 ; i < n ; i++) {
                vertex( x + r * sin( 2.0 * PI / n * i),
                        y - r * cos( 2.0 * PI / n * i) );
            }
            endShape(CLOSE);
 
        }
        // 星形を描く
        // x,y : 中心点の座標
        // r : 半径
        // n : 角の数
        private function drawNStar( x:Number, y:Number, 
                    r:Number,n:Number) : void
        {
            var i:int;
            noFill();
            if( n % 2 == 1) {
                beginShape();
                for( i = 0 ; i < n ; i++ ) {
                    i = i % n;
                    vertex( x + r * sin( 2.0 * PI / n *(( 2 * i)% n)),
                            y - r * cos( 2.0 * PI / n *(( 2 * i)% n)) );
                }
                endShape(CLOSE);
            } else {
                beginShape();
                for( i = 0 ; i < n ; i++ ) {
                    i = i % n;
                    vertex( x + r * sin( 2.0 * PI / n * 2 * i),
                            y - r * cos( 2.0 * PI / n * 2* i) );
                }
                endShape(CLOSE);   
                beginShape();
                for( i = 0 ; i < n ; i++ ) {
                    i = i % n;
                    vertex( x + r * sin( 2.0 * PI / n * (2 * i + 1)),
                            y - r * cos( 2.0 * PI / n * (2 * i + 1)) );
                }
                endShape(CLOSE);                
            }
        }

    }
}