/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pJ1A
 */

package {
    import flash.events.Event;
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    
    [SWF(frameRate=60, width=465, height=465)]
    public class FS_Revisited extends Sprite {
        private var _canvas:Bitmap;
        private var _canvasData:BitmapData;
        private var _oclMap:Vector.<Vector.<int>>;
        private var _pixels:Vector.<Vector.<int>>;
        private var _chunks:Vector.<Vector.<Vector.<int>>>;
        
        public function FS_Revisited() {
            this._canvasData = new BitmapData(465, 465, false, 0x000000);
            this._canvas = new Bitmap(this._canvasData);
            this._oclMap = new Vector.<Vector.<int>>();
            this._pixels = new Vector.<Vector.<int>>(true, 465*465);
            
            for (var $y:int = 0; $y<465; $y++) {
                this._oclMap[$y] = new Vector.<int>(true);
                
                for (var $x:int = 0; $x<465; $x++) {
                    ($x < 2 || $y < 2 || $x > 464 || $y > 464) ? this._oclMap[$y][$x] = 0 : this._oclMap[$y][$x] = 1;
                }
            }
            
            this.addEventListener(Event.ADDED_TO_STAGE, this.addedToStageHandler);
        }
        
        private function addedToStageHandler($event:Event):void {
            this.removeEventListener(Event.ADDED_TO_STAGE, this.addedToStageHandler);
            
            this.addChild(this._canvas);
            this.addPixel(2, 2, 3, 2);
            
            this.addEventListener(Event.ENTER_FRAME, this.enterFrameHandler);
        }
        
        private function addPixel($x:int, $y:int, $vX:int, $vY:int):void {
            this._pixels[this._pixels.length-1] = new <int>[$x, $y, $vX, $vY];
        }
        
        /**
         * Divide the colission map into chunks to optimize collission handling
         */
        private function enterFrameHandler($event:Event):void {
            for (var $:int = 0; $<this._pixels.length; $++) {
                this._pixels[$][0] += this._pixels[$][2];
                this._pixels[$][1] += this._pixels[$][3];
                this._canvasData.setPixel(this._pixels[$][0], this._pixels[$][1], 0xFFFFFF);
            }
        }
    }
}

Class {
    class Pixel {
        public var x:int;
        public var y:int;
        public var velX:int;
        public var velY:int;
        public var chunkX:int;
        public var chunkY:int;
        
        public function Pixel($x:int, $y:int, $size:int, $flag:int) {
            this.x = $x;
            this.y = $y;
            this.velX = 0;
            this.velY = 0;
        }
    }
}

Class {
    class PixelCanvas {
        public static var chunkSize;
    }
}


