/**
 * Copyright 110100110101101 ( http://wonderfl.net/user/110100110101101 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pInY
 */

package {
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            // write as3 code here..
            addChild( new Test() );
        }
    }
}


    class Test extends Sprite{
        public function Test(){
            var note:Note = new Note( this );
            
            var item:ItemA = new ItemA();
            
            var i:int;
            var iMax:int = 1000000;
            
            note.text = iMax.toString() + " loop\n";
            
            note.start();
            for( i=0; i<iMax; ++i ){
            }
            note.end( " msec : for(){} only \n");
            
            note.start();
            for( i=0; i<iMax; ++i ){
                item.a = 1;
            }
            note.end( " msec : item.a = 1; \n");
            
            note.start();
            for( i=0; i<iMax; ++i ){
                item.b = 1;
            }
            note.end( " msec : item.dynamicObject = 1; \n");
            
            
            
            note.start();for( i=0; i<iMax; ++i ){
                item.array[0xFFFFFF] = 1;
            }note.end( " msec : item.array[0xFFFFFF] = 1; \n");
            
            
            note.start();for( i=0; i<iMax; ++i ){
                item.array2D[0xFFF][0xFFF] = 1;
            }note.end( " msec : item.array2D[0xFFF][0xFFF] = 1; \n");
            
            note.start();for( i=0; i<iMax; ++i ){
                item.array3D[0xFF][0xFF][0xFF] = 1;
            }note.end( " msec : item.array3D[0xFF][0xFF][0xFF] = 1; \n");
            
            
        }
    }
    
    
    dynamic class ItemA{
        public function ItemA(){
            array2D = createArray2D( 0, 0xFFF, 0xFFF );
            array3D = createArray3D( 0, 0xFF, 0xFF, 0xFF );
        }
        public function createArray2D( value:Object=null, yMax:int=0, xMax:int=0 ):Array{
            var result:Array = [];
            for( var y:int=0; y<=yMax; ++y ){
                result[y] = []
                for( var x:int=0; x<=xMax; ++x ){
                    result[y][x] = value;
                }
            }
            return result;
        }
        public function createArray3D( value:Object=null, zMax:int=0, yMax:int=0, xMax:int=0 ):Array{
            var result:Array = [];
            for( var z:int=0; z<=zMax; ++z ){
                result[z] = []
                for( var y:int=0; y<=yMax; ++y ){
                    result[z][y] = []
                    for( var x:int=0; x<=xMax; ++x ){
                        result[z][y][x] = value;
                    }
                }
            }
            return result;
        }
        /**
        public function createArray4D( value:Object=null, wMax:int=0, zMax:int=0, yMax:int=0, xMax:int=0 ):Array{
            var result:Array = [];
            for( var w:int=0; w<wMax; ++w ){
                result[w] = []
                for( var z:int=0; z<zMax; ++z ){
                    result[w][z] = []
                    for( var y:int=0; y<yMax; ++y ){
                        result[w][z][y] = []
                        for( var x:int=0; x<xMax; ++x ){
                            result[w][z][y][x] = value;
                        }
                    }
                }
            }
            return result;
        }
        */
        
        public var a:int = 0;
        public var object:Object = new Object();
        public var array:Array = [];
        public var array2D:Array = [];
        public var array3D:Array = [];
    }
    




    /////////////////////////////////////////////////////////////////////
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.utils.getTimer;
    /**
    表示だけなら1行で書ける形の着想元
    ! MinimalComps の com.bit101.components.Component 
    https://github.com/minimalcomps/minimalcomps/blob/master/src/com/bit101/components/Component.as
    */
    class Note extends Sprite {
        public function Note( parent:Sprite=null, text:String=" ", x:Number=0,y:Number=0,widthX:Number=200,widthY:Number=100 ){
            
            shape = new Shape();
            bitmap = new Bitmap( new BitmapData( 1,1, true, 0x00000000 ) );
            
            textFormat = new TextFormat()
            textFormat.leftMargin = 0
            textFormat.rightMargin = 0
            textFormat.align = "left"
            textFormat.font = "_等幅"     //EXAMPLE  "_等幅"  "_ゴシック"  "_明朝 "  "_typewriter"  "_serif"  "_sans"
            textFormat.size = 10
            
            textField = new TextField()
            textField.background = false;
            textField.backgroundColor = 0xFFFFFF;
            textField.border = false;
            textField.borderColor = 0x000000;
            textField.textColor = 0x000000;
            textField.autoSize = "left";
            textField.selectable = false;
            textField.text = text;
            textField.defaultTextFormat = textFormat;
            
            this.text = text;
            this.x = x;
            this.y = y;
            textField.width = widthX;
            textField.height = widthY;
            
            displayEnable( parent );
            
            addEventListener( Event.ENTER_FRAME, onEnterFrame );
            
        }
        
        private function onEnterFrame( event:Event ):void {
            textField.text = text;
        }
        
        public function displayEnable( parent:Sprite ):void{
            if( parent ){
                parent.addChild( this );
                addChild( textField );
                addChild( shape );
                addChild( bitmap );
            }
        }
        
        public function displayDisenable():void{
            if( parent ){
                parent.removeChild( this );
                removeChild( textField );
                removeChild( shape );
                removeChild( bitmap );
            }
        }
        
        public function start( startText:String = "" ):void{
            startTime = getTimer();
            text = text + startText;
        }
        public function end( endText:String = "" ):void{
            endTime = getTimer();
            elapsedTime = endTime - startTime;
            text = text + elapsedTime.toString() + endText;
        }
        
        public function toBitmapData():BitmapData{
            var result:BitmapData
            result = new BitmapData( this.width, this.height, true, 0x00000000 );
            result.draw( this );
            return result;
        }
        
        public var elapsedTime:Number = 0;
        public var endText:String = "";
        public var endTime:Number = 0;
        public var iMax:uint = 1000000;
        public var startText:String = "";
        public var startTime:Number = 0;
        
        
        public var text:String
        public var textFormat:TextFormat
        public var textField:TextField
        public var bitmap:Bitmap;
        public var shape:Shape
    }