/**
 * Copyright dahex ( http://wonderfl.net/user/dahex )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pISS
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.media.Camera;
    import flash.media.Video;
    import flash.net.NetConnection;
    import flash.net.NetStream;
    import flash.ui.Mouse;
    import flash.ui.MouseCursor;
    
    import mx.utils.HSBColor;

    [SWF(width=465, height=465, backgroundColor=0x0, frameRate=30)]
    public class Halftone extends Sprite
    {
        private const Margin:uint = 8;
        private const Radius:Number = 3;
        
        private const UseCamera:Boolean = true;
        
        private var _head:Particle;
        private var _video:Video;
        private var _bmpData:BitmapData;
        private var _bmp:Bitmap;
        
        public function Halftone()
        {
            init(stage.stageWidth, stage.stageHeight);
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            stage.addEventListener(MouseEvent.CLICK, mouseClickHandler);
            Mouse.cursor = MouseCursor.BUTTON;
        }
        
        private function init(width:uint, height:uint):void
        {
            _video = new Video();
            
            if (UseCamera) {
                _video.attachCamera(Camera.getCamera());
            } else {
                var connection:NetConnection;
                var stream:NetStream;
                connection = new NetConnection();
                connection.connect(null);
                
                stream = new NetStream(connection);
                stream.client = {
                    onMetaData:function(param:Object):void
                    {
                    }
                };
                stream.play("hogehoge.mp4");
                _video.attachNetStream(stream);
            }
            
            var curr:Particle;
            var prev:Particle;
            var odd:Boolean = false;
            for (var y:uint = Margin; y < height; y+=Margin) {
                for (var x:uint = odd ? Margin : Margin/2; x < width; x+=Margin) {
                    curr = new Particle(x, y, HSBColor.convertHSBtoRGB(x/width*360, 0.7, 1.0));
                    if (prev) {
                        prev.next = curr;
                    } else {
                        _head = curr;
                    }
                    prev = curr;
                }
                odd = !odd;
            }
            
            _bmpData = new BitmapData(width, height, false);
            _bmp = new Bitmap(_bmpData);
            _bmp.visible = false;
            stage.addChildAt(_bmp, 0);
        }
        
        private function enterFrameHandler(evt:Event=null):void
        {
            var mat:Matrix = new Matrix();
            if (UseCamera) {
                mat.scale(-_bmpData.width / _video.width, _bmpData.height / _video.height);
                mat.translate(_bmpData.width, 0);
            } else {
                mat.scale(_bmpData.width / _video.width, _bmpData.height / _video.height);
            }
            _bmpData.draw(_video, mat);
            
            graphics.clear();
            for (var p:Particle = _head; p != null; p = p.next) {
                var d:uint = _bmpData.getPixel(p.x, p.y);
                var r:uint = (d & 0xFF0000) >> 16;
                var g:uint = (d & 0x00FF00) >> 8;
                var b:uint = (d & 0x0000FF);
                var l:Number = Math.sqrt(r*r + g*g + b*b) / 443; // 443 = Math.sqrt(3*256*256)
                p.setRadius(l*Radius+1);
                graphics.beginFill(p.c);
                graphics.drawCircle(p.x, p.y, p.r);
                graphics.endFill();
            }
        }
        
        private function mouseClickHandler(event:MouseEvent):void
        {
            _bmp.visible = !_bmp.visible;
        }
    }
}

class Particle
{
    public var x:uint;
    public var y:uint;
    public var c:uint;
    public var r:Number;
    public var next:Particle;
    public function Particle(x:uint, y:uint, c:uint=0xFFFFFF, r:Number=1.0, next:Particle=null) {
        this.x = x;
        this.y = y;
        this.c = c;
        this.r = 1;
        next = next;
    }
    public function setRadius(value:Number):void
    {
        if (Math.abs(r - value) < 0.1) {
            r = value;
        } else if (r < value) {
            r += 0.2;
        } else if (r > value) {
            r -= 0.4;
        }
    }
}