/**
 * Copyright set0 ( http://wonderfl.net/user/set0 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pIFy
 */

package 
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
   
    [SWF(width=465, height=465, frameRate=60, backgroundColor=0x000000)]
    public class FlashTest3d08 extends Sprite
    {
		private const MAX_SP:int = 200;
		private const SHAPE_SIZE:Number = 20;
		private const LINE_SIZE:Number = 8;
		
        private var sp_list_1:Array = [];
		private var sp_list_2:Array = [];
        private var flag:Boolean = true;
        private var mode:int = 0;
        private var buffer:BitmapData = new BitmapData(465, 465, false, 0x000000);
        private var screen:Bitmap = new Bitmap(buffer);
        private var count:int = 0;
		private var color_1:uint = 0xff9900;
		private var color_2:uint = 0x66ff66;
       
        public function FlashTest3d08()
        {
            Wonderfl.capture_delay(15);
            addChild(screen);
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
       
        private function onEnterFrame(e:Event):void
        {
            if(mode == 0) {
                sp_list_1.push(new Plus(count, 0));
				sp_list_2.push(new Plus(count, 1));
				sp_list_1.sortOn("z", Array.DESCENDING | Array.NUMERIC);
				sp_list_2.sortOn("z", Array.DESCENDING | Array.NUMERIC);
                count++;
            }
            
            var max:int = sp_list_1.length;
            
            if (mode == 0 && max > MAX_SP) {
                mode = 1;
            }
            
            var shape:Shape = new Shape();
            var tmp_line_size:Number;
            var tmp_shape_size:Number;
			var tmp_shape_size_half:Number;
			var tmp_shape_center:Number;
            
            switch(mode) {
                case 0:
                case 1:
                    for (var i:int = 0; i < max; i++) {
                        sp_list_1[i].setPosition(stage.mouseX, stage.mouseY);
						sp_list_2[i].setPosition(stage.mouseX, stage.mouseY);
                    }
                    
                    if (max >= MAX_SP) {
                        mode = 2;
						count = MAX_SP;
                    }
                    break;
                
                case 2:
                    var end_flag:Boolean = true;
                    
                    for (i = 0; i < max;i++) {
                       	if(sp_list_1[i].move(stage.mouseX, stage.mouseY) == true) {
								end_flag = false;
						 }
						 sp_list_2[i].move(stage.mouseX, stage.mouseY);
					}

					    
                    if (end_flag == true) {
                        mode = 3;
                    }
                    break;
                
                default:
                    for (i = 0; i < max; i++) {
                        sp_list_1[i].setPosition(stage.mouseX, stage.mouseY);
						sp_list_2[i].setPosition(stage.mouseX, stage.mouseY);
                    }
                    break;
            }
            
            for (i = 0; i < max; i++) {
                tmp_line_size = LINE_SIZE * sp_list_1[i].scale;
                tmp_shape_size = SHAPE_SIZE * sp_list_1[i].scale;
				tmp_shape_size_half = tmp_shape_size / 2;
				tmp_shape_center = tmp_shape_size / 2 + tmp_line_size / 2;
                
                if (tmp_line_size < 0.01 || tmp_shape_size < 0.01) {
                    continue;
                }
                
                shape.graphics.lineStyle(tmp_line_size, 0x66ff66, 0.8, false, "normal", CapsStyle.SQUARE);
                shape.graphics.moveTo(sp_list_1[i].x + tmp_shape_size_half, sp_list_1[i].y);
                shape.graphics.lineTo(sp_list_1[i].x + tmp_shape_size_half, sp_list_1[i].y + tmp_shape_size);
                shape.graphics.moveTo(sp_list_1[i].x, sp_list_1[i].y + tmp_shape_size_half);
                shape.graphics.lineTo(sp_list_1[i].x + tmp_shape_size, sp_list_1[i].y + tmp_shape_size_half);
				
                shape.graphics.moveTo(sp_list_2[i].x + tmp_shape_size_half, sp_list_2[i].y);
                shape.graphics.lineTo(sp_list_2[i].x + tmp_shape_size_half, sp_list_2[i].y + tmp_shape_size);
                shape.graphics.moveTo(sp_list_2[i].x, sp_list_2[i].y + tmp_shape_size_half);
                shape.graphics.lineTo(sp_list_2[i].x + tmp_shape_size, sp_list_2[i].y + tmp_shape_size_half);
				
				if (mode == 3 && i >= count &&  i < max - 1) {
					shape.graphics.lineStyle(1, color_2, 0.8, false, "normal", CapsStyle.SQUARE);
					shape.graphics.beginFill(color_2, 0.3);
					shape.graphics.moveTo(sp_list_1[i].x + tmp_shape_center, sp_list_1[i].y + tmp_shape_center);
					shape.graphics.lineTo(sp_list_2[i].x + tmp_shape_center, sp_list_2[i].y + tmp_shape_center);
					shape.graphics.lineTo(sp_list_2[i + 1].x + tmp_shape_center, sp_list_2[i + 1].y + tmp_shape_center);
					shape.graphics.lineTo(sp_list_1[i + 1].x + tmp_shape_center, sp_list_1[i + 1].y + tmp_shape_center);
					shape.graphics.lineTo(sp_list_1[i].x + tmp_shape_center, sp_list_1[i].y + tmp_shape_center);
				}
				
				if (mode == 4 && i >= count &&  i < max - 1) {
					shape.graphics.lineStyle(1, color_1, 0.8, false, "normal", CapsStyle.SQUARE);
					shape.graphics.beginFill(color_1, 0.3);
					shape.graphics.moveTo(sp_list_1[i].x + tmp_shape_center, sp_list_1[i].y + tmp_shape_center);
					shape.graphics.lineTo(sp_list_2[i].x + tmp_shape_center, sp_list_2[i].y + tmp_shape_center);
					shape.graphics.lineTo(sp_list_2[i + 1].x + tmp_shape_center, sp_list_2[i + 1].y + tmp_shape_center);
					shape.graphics.lineTo(sp_list_1[i + 1].x + tmp_shape_center, sp_list_1[i + 1].y + tmp_shape_center);
					shape.graphics.lineTo(sp_list_1[i].x + tmp_shape_center, sp_list_1[i].y + tmp_shape_center);
				} else if(mode == 4 &&  i < max - 1) {
					shape.graphics.lineStyle(1, color_2, 0.8, false, "normal", CapsStyle.SQUARE);
					shape.graphics.beginFill(color_2, 0.3);
					shape.graphics.moveTo(sp_list_1[i].x + tmp_shape_center, sp_list_1[i].y + tmp_shape_center);
					shape.graphics.lineTo(sp_list_2[i].x + tmp_shape_center, sp_list_2[i].y + tmp_shape_center);
					shape.graphics.lineTo(sp_list_2[i + 1].x + tmp_shape_center, sp_list_2[i + 1].y + tmp_shape_center);
					shape.graphics.lineTo(sp_list_1[i + 1].x + tmp_shape_center, sp_list_1[i + 1].y + tmp_shape_center);
					shape.graphics.lineTo(sp_list_1[i].x + tmp_shape_center, sp_list_1[i].y + tmp_shape_center);
				}
            }
			
			if (mode == 3) {
				count--;
				if (count <= 0) {
					count = MAX_SP;
					mode = 4;
				}
			}
			
			if (mode == 4) {
				count--;
				if (count <= 0) {
					count = MAX_SP;
					var tmp_color:uint = color_1;
					color_1 = color_2;
					color_2 = tmp_color;
				}
			}
			
            buffer.colorTransform(buffer.rect, new ColorTransform(0, 0, 0, 0, 0, 0, 0, 0));
			buffer.draw(shape);
        }
    }
}

import flash.display.*;
const T_RAD:Number = Math.PI / 180;
const FL:Number = 100;
const INTERVAL:Number = 30;
const CENTER_X:Number = 232.5;
const CENTER_Y:Number = 232.5;

class Plus
{
    public var x:Number;
    public var y:Number;
    public var z:Number;
    public var init_x:Number;
    public var init_y:Number;
    public var scale:Number;
    public var r_end:Number;
    public var r_count:Number;
	public var position:int;
    
    public function Plus(count:int, position:int) 
    {
        this.init_x = (position * 2 - 1)  * 500; 
        this.init_y = CENTER_Y / 2;
        this.z = count * INTERVAL;
        this.r_end = count * 3;
        this.r_count = 0;
		this.position = position;
    }
    
    public function setPosition(x:Number, y:Number):void
    {
        var scale:Number = FL / (FL + this.z);
    
		this.x = (this.init_x + (CENTER_X - x) * 10) * scale + CENTER_X;
        this.y = (this.init_y + (CENTER_Y - y) * 10) * scale + CENTER_Y;
        this.scale = scale;    
    }
    
    public function move(x:Number, y:Number):Boolean
    {
        if (this.r_count < this.r_end) {
            this.r_count += 10;
			this.setPosition(x, y);
			return true;
        }
        
		var r:Number = (this.r_end + 180 * this.position) * T_RAD;
    	this.init_x = Math.cos(r) * 500;
		this.init_y = Math.sin(r) * 500;
        
		this.setPosition(x, y);
        return false;
    }
}