/**
 * Copyright okoi ( http://wonderfl.net/user/okoi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pHmX
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.Shape;
    import flash.display.Graphics;
    
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    
    import flash.geom.Point;
    
    [SWF(width = "465", height = "465", frameRate="60")]
    
    /**
     * ...
     * @author 
     */
    public class Main extends Sprite 
    {
        private var _particles:Vector.<Particle>;
        private var step:int;
                
        private var eyeimgsizemax:int;
        private var eyeimgsizemin:int;
        private var eyeimglist:Object;
        
        private var canvas:BitmapData;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            graphics.beginFill(0);
            graphics.drawRect(0, 0, WIDTH, HEIGHT);
            graphics.endFill();
                        
            canvas = new BitmapData(WIDTH, HEIGHT, true, 0);
            addChild( new Bitmap( canvas ) );
            
            _particles = new Vector.<Particle>();
            
            InitEyeImageList();
            
            
            addEventListener( Event.ENTER_FRAME, EnterFrameHandler );
        }
        
        private function InitEyeImageList() : void
        {
            eyeimglist = new Object();
            
            eyeimgsizemin = 1;
            eyeimgsizemax = 10;
            
            for ( var radius:int = 1; radius <= 10; radius++ )
            {
                var eye:Eye = new Eye( radius );
                eyeimglist["" + radius] = eye;
            }
        }
        
        
        private function AddParticle() : void
        {
            var p:Particle = new Particle();
            p.x = Math.random() * WIDTH;
            p.z = Math.random() * HEIGHT / 2 + HEIGHT / 2;
            _particles.push( p );
        }
        
        private function EnterFrameHandler( e:Event ) : void
        {            
            canvas.lock();
            canvas.fillRect( canvas.rect, 0 );
           var pnum:int = _particles.length;
            for ( var i:int = pnum - 1; i >= 0; i-- )
            {
                _particles[i].Move(mouseX, mouseY);
                
                if ( _particles[i].life == 0 )    _particles.splice( i, 1 );
                else
                {
                    var x:Number = _particles[i].x;
                    var y:Number = _particles[i].z - _particles[i].y;
                    var sin:Number = Math.sin( (_particles[i].life / Particle.LIFE_MAX) * 180 * Math.PI / 180 );
                    var size:int = int( Math.max( eyeimgsizemax * sin, eyeimgsizemin ) );
                    
                    var eyeimg:Eye = eyeimglist[""+size];
                    canvas.copyPixels( 
                            eyeimg.bmd,
                            eyeimg.bmd.rect,
                            new Point( x - eyeimg.radius, y - eyeimg.radius ),
                            null,
                            null,
                            true
                            );                    
                }
            }            
            canvas.unlock();
            
            
            AddParticle();
        }
        
    }
    
}

import flash.display.BitmapData;
import flash.display.Shape;

const WIDTH:int = 465;
const HEIGHT:int = 465;


class Particle {
    
    public static const LIFE_MAX:int = 2000;
    
    public var x:Number;
    public var y:Number;
    public var z:Number;
    
    public var rolPower:Number;
    public var upPower:Number;
    public var life:Number;
    
    public function Particle() {
        life = LIFE_MAX;
        rolPower = 80;
        upPower = 0;
        x = 0;
        y = 0;
        z = 0;
    }
    
    
    public function Move(tx:Number, tz:Number) : void
    {
        var sin:Number = Math.sin( (45 + rolPower) / 180 * Math.PI );
        var cos:Number = Math.cos( (45 + rolPower) / 180 * Math.PI );
        rolPower *= 0.999;
        
        var vecX:Number = (x - tx);
        var vecZ:Number = (z - tz); 
        var vx : Number = vecX * cos + vecZ * -sin;
        var vz : Number = vecX * sin + vecZ * cos;
        var r : Number = Math.sqrt(vx * vx + vz * vz);
        
        vx /= r; 
        vz /= r;
        
        x += vx * 4 * 5;
        z += vz * 1 * 5;
        
        y += upPower;
        upPower += 0.001;

        if( life > 0 )    life--;
    }
    
    
}

class Eye {
    public var bmd:BitmapData;
    
    private var _radius:Number;
    
    public function Eye(r:Number = 10) {
        
        _radius = r;
        
        bmd = new BitmapData(_radius * 2, _radius * 2, true, 0);
        var s:Shape = new Shape();
            s.graphics.beginFill(0xff0060);
            s.graphics.drawCircle(r,r,r);
            s.graphics.endFill();
            s.graphics.beginFill(0xc00000);
            s.graphics.drawCircle(r,r,5*r/8);
            s.graphics.endFill();
            s.graphics.beginFill(0xffffff);
            s.graphics.drawCircle(5*r/4,r/2,r/4);
            s.graphics.endFill();
        bmd.draw(s);
    }
    
    public function get radius():Number { return    _radius;    }

}
