/**
 * Copyright potasso ( http://wonderfl.net/user/potasso )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pHhb
 */

/**
 * by Victor Potasso
 * www.vitorpotasso.com
 */
package 
{
    import flash.display.Graphics;
    import flash.utils.Timer;
    import flash.display.Sprite;
    import flash.events.TimerEvent;
    import net.hires.debug.Stats;
    import caurina.transitions.Tweener;

    /**
     * @author Victor Potasso
     */
    public class LinesEffect extends Sprite 
    {
        private var cont:Sprite;
        private var numLines:int = 150;
        private var timeLines:int = 50;
        private var w:Number = stage.stageWidth;
        private var h:Number = stage.stageHeight;
        private var a:int = Math.random()*3;

        /**
         * Constructor
         */
        public function LinesEffect() 
        {
            this.initialize();
        }
        
        
        /**
         * Initialize
         */
        private function initialize ():void
        {
            
            this.cont = new Sprite();
            addChild( this.cont );
            
            var timer:Timer = new Timer( this.timeLines );
            timer.addEventListener(TimerEvent.TIMER, this.render, false, 0, true);    
            timer.start();
            
            addChild(new Stats());
        }
        
        /**
         * Create a object Line
         *
         * @param tickness     int
         * @param color        Number
         * @param alpha        Number
         * @param lineX        Number
         * @param lineY        Number
         * @param moveX        Number 
         * @param moveY        Number
         * @param curveX       Number
         * @param curveY       Number
         */
        private function createLine (tickness:int, color:Number, alpha:Number, lineX:Number, lineY:Number, moveX:Number, moveY:Number, curveX:Number, curveY:Number):void
        {
            var objSprite:Sprite = new Sprite();
            var objLine:Graphics = objSprite.graphics;
            
            objLine.lineStyle(tickness, color, alpha);
            objLine.moveTo(moveX, moveY);
            objLine.lineTo(lineX, lineY);
            objLine.curveTo(100, 100, curveX, curveY);
            
            cont.addChild(objSprite);
            animation ( objSprite );
        }
        
        /**
         * Animation
         * @param obj        Sprite
         */
        private function animation (obj:Sprite):void
        {
            obj.scaleY = obj.scaleX = obj.alpha= 0;
            Tweener.addTween(obj, { scaleX:1, scaleY:1, alpha:1, time:this.a, transition:"easeOutCubic"} );
        }
        
        /**
         * Render
         */
        private function render (evt:TimerEvent):void
        {
            
            this.createLine(
                Math.random()* 20,
                Math.random()* 0xFFFFFF,
                Math.random()* (.3 + 4),
                Math.random()* this.w, 
                Math.random()* this.h, 
                Math.random()* this.w,
                Math.random()* this.h,
                Math.random()* 300,
                Math.random()* 300
            );
                
            if (this.cont.numChildren > this.numLines)
            {
                var temp:Sprite = Sprite(cont.getChildAt(0))
                cont.removeChild(temp);  
                temp = null; 
                trace("test:", cont.numChildren);
            }
        }
    }
}