/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pHZS
 */

package {
  import flash.display.*;
  import flash.events.MouseEvent;
  import flash.geom.Matrix3D;
  import flash.geom.Vector3D;
  
  [SWF(width="500",height="500")]
  public class ch34ex6 extends Sprite {
    protected const targetSphereRadius:Number = 180; 
    protected var holder:Sprite;
    protected var target:Shape;
    protected var arrow:Shape;
    public function ch34ex6() {
      holder = new Sprite();
      holder.x = stage.stageWidth/2; holder.y = stage.stageHeight/2;
      addChild(holder);
      makeArrow();
      makeTarget();
      stage.addEventListener(MouseEvent.CLICK, pointToRandom);
      pointToRandom(null);
    }
    protected function makeTarget():void {
      var SIZE:Number = 10;
      target = new Shape();
      target.graphics.beginFill(0xff0000, 0.8);
      target.graphics.drawCircle(0,0, SIZE);
      holder.addChild(target);
      
      holder.graphics.lineStyle(0, 0, 0.8);
      holder.graphics.drawCircle(0, 0, targetSphereRadius);
    }
    protected function makeArrow():void {
      var SIZE:Number = 20, ARROW_SIZE:Number = 9, LINE_WIDTH:Number = 4;
      arrow = new Shape();
      arrow.graphics.lineStyle(LINE_WIDTH, 0, 1, false,
        LineScaleMode.NORMAL, CapsStyle.NONE, JointStyle.MITER, ARROW_SIZE);
      arrow.graphics.moveTo(-SIZE, 0);
      arrow.graphics.lineTo(SIZE-LINE_WIDTH/2, 0);
      
      arrow.graphics.moveTo(SIZE-ARROW_SIZE, ARROW_SIZE);
      arrow.graphics.lineTo(SIZE, 0);
      arrow.graphics.lineTo(SIZE-ARROW_SIZE, -ARROW_SIZE);
      holder.addChild(arrow);
    }
    protected function pointToRandom(event:MouseEvent):void {
      var r:Function = function():Number {return Math.random() - 0.5;}
      var randomDirection:Vector3D = new Vector3D(r(), r(), r());
      randomDirection.normalize();
      randomDirection.scaleBy(targetSphereRadius);
      m = new Matrix3D();
      m.position = randomDirection;
      target.transform.matrix3D = m;
      
      var m:Matrix3D = new Matrix3D();
      m.pointAt(randomDirection, Vector3D.X_AXIS, Vector3D.Z_AXIS);
      arrow.transform.matrix3D = m;
    }
  }
}