/**
 * Copyright jloa ( http://wonderfl.net/user/jloa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pG0A
 */

package 
{
    import flash.display.Graphics;
    import flash.events.Event;
    import flash.display.Sprite;
    
    [SWF(backgroundColor="#000000", frameRate="31")]
    public class FlashTest extends Sprite
    {
        private var pool:Vector.<SnowFlake> = new Vector.<SnowFlake>();
        private var n:int = 200;
        
        public function FlashTest()
        {
            addEventListener(Event.ADDED_TO_STAGE, init);   
            var g:Graphics = this.graphics;
            g.clear(); g.beginFill(0); g.drawRect(0, 0, stage.stageWidth, stage.stageHeight); g.endFill();         
        }
        
        private function init(e:Event):void
        {
            for(var i:int = 0; i < n; ++i)
            {
                var flake:SnowFlake = new SnowFlake();
                flake.x = Math.random() * stage.stageWidth;
                flake.y = Math.random() * -stage.stageHeight;
                addChild(flake); pool.push(flake);
            }
            
            removeEventListener(Event.ADDED_TO_STAGE, init); 
            addEventListener(Event.ENTER_FRAME, renderSnowFlakes);
        }
        
        private function renderSnowFlakes(e:Event):void
        {
            for(var i:int = 0; i < n; ++i)
            {
                var angle:Number = pool[i].y*5*(Math.PI/180);
                pool[i].y += pool[i].speedY;
                pool[i].x += Math.sin(angle)*(.5 + 1.5*Math.random());
                if(pool[i].y > stage.stageHeight)
                {
                    pool[i].x = Math.random() * stage.stageWidth;
                    pool[i].y = Math.random() * -stage.stageHeight;
                }
            }
        }
    }
}
import flash.filters.BlurFilter;
import flash.display.Shape;
internal class SnowFlake extends Shape
{
    public var speedY:Number = .5 + Math.random()*1.5;
    public var sizeMax:int = 5;
    
    public function SnowFlake()
    {
        super();
        var r:Number = 1 + Math.random()*(sizeMax - 1);
        this.graphics.clear();
        this.graphics.beginFill(0xffffff, alphaR(r));
        this.graphics.drawCircle(0, 0, r);
        this.graphics.endFill();
        this.filters = [new BlurFilter(2 + Math.random()*3, 2 + Math.random()*2, 2)];
        this.cacheAsBitmap = true;
    }
    
    private function alphaR(r:Number):Number
    {
        return (r > sizeMax/2) ? .1 + Math.random()*.9 : 0.5 + Math.random()*.5;
    }
}