/**
 * Copyright seikai ( http://wonderfl.net/user/seikai )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pEdZ
 */

package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Point;
	
	import frocessing.color.ColorHSV;
	
	[SWF(width = 465, height = 465, frameRate = 30, backgroundColor=0)]
	public class Main extends Sprite
	{
		private var _view:BitmapData;
		private var _canvas:Sprite;
		private var _line:Sprite;
		private var _radian:Number = 0;
		private var _hsv:ColorHSV;
		private const RADIUS:int = 100;
		private const BLUR:BlurFilter = new BlurFilter(2, 2, 1);
		private const ZERO_P:Point = new Point(0, 0);
		
		public function Main()
		{
			if(stage){
				_init();
			}else {
				addEventListener(Event.ADDED_TO_STAGE, _init);
			}
		}
		
		private function _init(e:Event=null):void
		{
			_hsv = new ColorHSV();
			
			_view = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x000000);
			addChild(new Bitmap(_view));
			
			_line = new Sprite();
			_line.graphics.lineStyle(5, 0xFFFFFF);
			_line.graphics.moveTo(-300, -125);
			_line.graphics.curveTo(180, 500, 370, 400);
			
			_canvas = new Sprite()
			_canvas.addChild(_line);
			
			addEventListener(Event.ENTER_FRAME, _draw);
		}
		
		private function _draw(e:Event):void
		{
			var w:Number = stage.stageWidth/2;
			_line.x = Math.cos(_radian) * RADIUS + w;
			_line.z = Math.sin(_radian) * RADIUS*2 + w;
			_line.y = Math.sin(_radian) * RADIUS*3 + w;
			_line.rotationY +=0.5;
			
			_hsv.h += 1;
			_line.transform.colorTransform = new ColorTransform(0, 0, 0, 1, _hsv.r, _hsv.g, _hsv.b);
			
			_radian += 1/90;
			_view.draw(_canvas);
			_view.applyFilter(_view, _view.rect, ZERO_P, BLUR);
			_view.scroll(0, -1);
		}
		
	}
}