/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pEVG
 */

package
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.text.*;
    
    [SWF(frameRate=60, width=465, height=465)]
    public class Main extends Sprite
    {
        private var _consoleOutput :Output;
        private var _framePosition :int;
        private var _frameCount :int;
        private var _timeStamp :String;
                
        public function Main()
        {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            _consoleOutput = new Output("modulo parsed, frame-based, time display!");
            
            addChild(_consoleOutput);
            
            addEventListener(Event.ENTER_FRAME, onFrame);
        }
        
        private function onFrame($e:*) :void
        {    
            _frameCount++;
            _framePosition++;
            
            (_frameCount == 60) ? timeParse(_framePosition) : null;
        }
        
        public function timeParse($n:Number) :void
        {
            _frameCount = 0;
            
            var $min :int;
            var $sec :int;
            
            $sec = (($n % 3600) / 60);
            $min = (($n - $sec) / 3600);
            
            ($sec<2) ? (($min<1) ? (_timeStamp = $sec + " Second") : (_timeStamp = $min + " Minutes and " + $sec + " Second"))
                     : (($min<1) ? (_timeStamp = $sec + " Seconds") : (_timeStamp = $min + " Minutes and " + $sec + " Seconds"));
            
            _consoleOutput.text = _timeStamp;
        }
    }
}

import flash.display.*;
import flash.events.*;
import flash.geom.*;
import flash.text.*;

class Output extends TextField
{
    private var _textFormat :TextFormat;
    
    protected var _x :Number;
    protected var _y :Number;
    protected var _font :String;
    protected var _size :Number;
    protected var _color :Number;
    protected var _content :String;
        
    public function Output($content:String, $x:Number = 1, $y:Number = 0, $color:Number = 0, $size:Number = 14, $font:String = "Helvetica")
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _x = $x;
        _y = $y;
        _font = $font;
        _size = $size;
        _color = $color;
        _content = $content;
        
        multiline = true;
        selectable = mouseEnabled = false;
        autoSize = TextFieldAutoSize.LEFT;
        antiAliasType = AntiAliasType.ADVANCED;
        _textFormat = new TextFormat(_font, _size, _color);
        defaultTextFormat = _textFormat;
    }
    
    public function addedToStage($e:Event) :void
    {
       removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
       
       _init(); 
    }
    
    public function _init() :void
    {
        x = _x;
        y = _y;
        appendText("\n"+_content);
    }
    
    public function get font() :String
    { return _font }
    public function get nWidth() :Number
    { return width }
    public function get color() :Number
    { return _color }
    
    public function set font($:String) :void
    { _font = $; _init() }
    public function set content($:String) :void
    { _content = $; _init() }
    public function set color($:Number) :void
    { _color = $; _init() }
}