/**
 * Copyright a24 ( http://wonderfl.net/user/a24 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pETY
 */

package
{
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.display.Shape;
	import flash.display.StageQuality;
	import flash.events.SampleDataEvent;
	import flash.media.Sound;
	import flash.utils.ByteArray;
	import net.hires.debug.Stats;
	
	[SWF(backgroundColor = "#000000", frameRate = 60)]
	
	public class SmokeTest extends Sprite
	{
		public function SmokeTest() 
		{
			stage.quality = StageQuality.MEDIUM;
			stage.addChild(new Stats());
			
			// ---------------------------------------
			// Background
			// ---------------------------------------
			graphics.beginFill(0);
			graphics.drawRect(0, 0, 465, 465);
			
			// ---------------------------------------
			// Item
			// ---------------------------------------
			graphics.beginFill(0xCCCCCC);
			graphics.drawRect(190, 340, 85, 90);
			
			var sp:Shape;
			sp = addChild(new Shape()) as Shape;
			sp.graphics.beginFill(0xCCCCCC);
			sp.graphics.drawCircle(232.5, 0, 42.5);
			sp.y = 430;
			sp.height = 14;
			
			sp = addChild(new Shape()) as Shape;
			sp.graphics.beginFill(0xAAAAAA);
			sp.graphics.drawCircle(232.5, 0, 42.5);
			sp.y = 340;
			sp.height = 14;
			
			// ---------------------------------------
			// Smoke
			// ---------------------------------------
			var smoke:Smoke = new Smoke();
			smoke.x = 232.5;
			smoke.y = 330;
			addChild(smoke);
			
			// ---------------------------------------
			// Sound
			// ---------------------------------------
			var sound:Sound = new Sound;
			sound.addEventListener (SampleDataEvent.SAMPLE_DATA, sampleDataHandler); 
			sound.play();
		}
		
		public function sampleDataHandler(e:SampleDataEvent):void
		{
			var noise:BitmapData = new BitmapData(100, 100);
			noise.noise(0, 50, 85, 1, false);
			
			var vol:Number    = 1e-3;
			var pix:ByteArray = noise.getPixels(noise.rect);
			var smp:ByteArray = new ByteArray;
			
			for (var i:int = 0; i < 8192; i++)
			{
				if (pix.bytesAvailable < 2) pix.position = 0;
				smp.writeFloat (pix.readByte () * vol);
				smp.writeFloat (pix.readByte () * vol);
			}
			e.data.writeBytes(smp);
		}
	}
}


import flash.display.Sprite;
import flash.events.Event;
import flash.filters.BlurFilter;

class Smoke extends Sprite
{
	private var _particles:Array;
	private var _pool:Array;
	private var _phase:Number;
	private var _generatX:Number;
	private var _generatY:Number;
	
	public function Smoke() 
	{
		_particles = [];
		_pool      = [];
		_phase     = 0;
		_generatX  = 0;
		_generatY  = 0;
		
		filters = [new BlurFilter(32, 32)];
		addEventListener(Event.ENTER_FRAME, rendering);
	}
	
	private function rendering(e:Event):void 
	{
		_phase += Math.random() * 0.2;
		
		var p:Particle;
		var n:int = 2 + Math.random() * 6;
		var c:Number = Math.cos(_phase) * 0.5;
		
		for (var i:int = 0; i < n; i ++)
		{
			p       = _pool.shift() || new Particle();
			p.x     = 0;
			p.y     = 0;
			p.vx    = -2.5 + Math.random() * 5 + c;
			p.vy    = -2.5 + Math.random() * -2.5;
			p.va    = -0.0088;
			p.alpha = 1;
			
			addChild(p);
			_particles.push(p);
		}
		
		var cont:int;
		for each (p in _particles)
		{
			p.x += p.vx;
			p.y += p.vy;
			p.vx *= 0.96;
			p.alpha += p.va;
			
			if (p.alpha < 0)
			{
				removeChild(p);
				_particles.splice(cont, 1);
				_pool.push(p);
			}
			cont ++;
		}
	}
}


import flash.display.Shape;

class Particle extends Shape
{
	public var vx:Number;
	public var vy:Number;
	public var va:Number;
	
	public function Particle():void
	{
		graphics.beginFill(0xFFFFFF);
		graphics.drawCircle(0, 0, 8);
	}
}