/**
 * Copyright k__ ( http://wonderfl.net/user/k__ )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pEQB
 */

package {
	import flash.display.*;
	import flash.filters.*;
	import flash.geom.*;
	import flash.events.Event;
	public class Main extends Sprite{
		private var canvas:Bitmap;
		private var disp:BitmapData, map:BitmapData, noise:BitmapData,neut:BitmapData;
		private var blur:BlurFilter, dmf:DisplacementMapFilter;
		private var lx:int = 0,ly:int = 0;
		private var brush:Sprite, g:Graphics;
		private var cnt:uint = 0;
		public function Main() {
			disp = new BitmapData(stage.stageWidth , stage.stageHeight);
			disp.noise(0,0,255,4);
			
			map = new BitmapData(stage.stageWidth , stage.stageHeight, false,0x800080);
			noise = new BitmapData(stage.stageWidth , stage.stageHeight);
			neut = new BitmapData(stage.stageWidth, stage.stageHeight,false, 0x880088);
			brush = new Sprite();
			g = brush.graphics;
			
			blur = new BlurFilter(16,16);
			
			lx = mouseX;
			ly = mouseY;
			addChild(new Bitmap(disp));
			addEventListener(Event.ENTER_FRAME, h_enterFrame);
		}
		
		private function h_enterFrame(evt:Event):void {
			dmf = new DisplacementMapFilter(
				map, new Point(0,0),BitmapDataChannel.RED, BitmapDataChannel.BLUE, 16,16);
			disp.applyFilter(disp,new Rectangle(0,0,disp.width, disp.height),new Point(0,0),dmf);
			
			var r:uint = Math.min(Math.max(lx -mouseX + 128, 0) , 255);
			var b:uint = Math.min(Math.max(ly - mouseY + 128, 0) , 255);
			var col:uint = (r <<16 | b);
			g.clear();
			g.lineStyle(80,col, 0.5);
			g.moveTo(lx,ly);
			g.lineTo(mouseX,mouseY);
			map.draw(brush);
			lx = mouseX;
			ly = mouseY;
			noise.noise(0,0,255,4);
			disp.draw(noise,new Matrix(),new ColorTransform(1,1,1,0.05,0,0,0,0));
			if (cnt ++ % 10 == 0) {
				map.applyFilter(map,new Rectangle(0,0,disp.width, disp.height),new Point(0,0),blur);
				map.draw(neut,new Matrix(),new ColorTransform(1,1,1,0.1,0,0,0,0));
			}
		}
	}
}