/**
 * Copyright psyark ( http://wonderfl.net/user/psyark )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pEF0
 */

// infinite-tank-entry
// デフォルトの行動ルーチンが0.5秒先を読んでるためか
// 相手に食い込めば撃ってこなくなるので、そこを利用
// 行動を書き直してる相手にはめっぽう弱い
package {
	import flash.display.Sprite;
	import flash.display.BitmapData;
	import flash.geom.Rectangle;
	import flash.geom.Matrix;
	
	import net.wonderfl.game.infinity_tank.development.*;
	import net.wonderfl.math.*;
	
	
	public class Tank extends TankBase {
		private var commands:int;
		private var tankAim:Number;
		private var gunAim:Number;
		
		private var tankVisual:Sprite;
		private var gunVisual:Sprite;
		private var tankAimVisual:Sprite;
		private var gunAimVisual:Sprite;
		
		public function Tank()  {
			_bulletRenderer = "http://swf.wonderfl.net/swf/usercode/0/04/046c/046cee45b4334c4f2dac8dfa7ec9ea2b2b2eb27d.swf";
			
			gunVisual = new Sprite();
			tankVisual = new Sprite();
			gunAimVisual = new Sprite();
			tankAimVisual = new Sprite();
			
			gunVisual.graphics.lineStyle(1, 0x000000);
			gunVisual.graphics.beginFill(0x0000FF);
			gunVisual.graphics.drawRect(-5, -5, 33, 10);
			
			tankVisual.graphics.lineStyle(1, 0x000000);
			tankVisual.graphics.beginFill(0x00FF00);
			tankVisual.graphics.drawRect(-25, -15, 50, 30);
			tankVisual.graphics.beginFill(0xFF0000);
			tankVisual.graphics.drawRect(20, -15, 5, 30);
			
			gunAimVisual.graphics.lineStyle(1, 0xFFFF00);
			gunAimVisual.graphics.lineTo(800, 0);
			
			tankAimVisual.graphics.lineStyle(3, 0xFF00FF);
			tankAimVisual.graphics.lineTo(800, 0);
			
			
		//	tankVisual.addChild(tankAimVisual);
			tankVisual.addChild(gunVisual);
		//	gunVisual.addChild(gunAimVisual);
			
			super();
		}
		
		override public function action():int {
			// 敵の位置を取得.
			var enemyPos:WVector2D = _scene.enemyTankPosition;
			// 自分の位置を敵の位置から引く.
			// 自分から見た敵の位置を計算
			enemyPos.subtract(_scene.myTankPosition);
			// 敵との距離
			var enemyDistance:Number = enemyPos.length;
			
			// 敵の速度を取得
			var enemySpeed:WVector2D = _scene.enemyTankLinearVelocity;
			// 0.5秒の位置を線形で予想
			enemySpeed.scale(0.5);
			enemyPos.add(enemySpeed);
			
			
			gunAim  = normalizeAngle(Math.atan2(enemyPos.y, enemyPos.x) - _scene.myTankAngle - _scene.myGunAngle);
			tankAim = normalizeAngle(Math.atan2(enemyPos.y, enemyPos.x) - _scene.myTankAngle);
			
			commands = 0;
			
			if (gunAim > 0) {
				commands |= Command.GUN_TURN_RIGHT;
			} else {
				commands |= Command.GUN_TURN_LEFT;
			}
			
			if (tankAim > 0) {
				commands |= Command.TANK_TURN_RIGHT;
			} else {
				commands |= Command.TANK_TURN_LEFT;
			}
			
			if (Math.abs(tankAim) < Math.PI * 0.15) {
				commands |= Command.TANK_MOVE_FORWARD;
			} else {
				commands |= Command.TANK_MOVE_BACKWARD;
			}
			
			if (Math.abs(gunAim) < Math.PI * 0.1 && _scene.myBulletCount == 0) {
				commands |= Command.FIRE;
			}
			if (Math.abs(gunAim) < Math.PI * 0.3 && enemyDistance < 100) {
				commands |= Command.FIRE;
			}
			
			return commands;
		}
		
		
		override public function draw(bitmapData:BitmapData):void {
			gunVisual.rotation = _scene.myGunAngle * 180 / Math.PI;
			gunAimVisual.rotation  = gunAim  * 180 / Math.PI;
			tankAimVisual.rotation = tankAim * 180 / Math.PI;
			
			var _mat:Matrix = new Matrix();
			_mat.rotate(_scene.myTankAngle);
			_mat.translate(_scene.myTankPosition.x, _scene.myTankPosition.y);
			
			bitmapData.fillRect(bitmapData.rect, 0x00000000);
			bitmapData.draw(tankVisual, _mat, null, null, null, true);
		}
		
		
		private function normalizeAngle(angle:Number):Number {
			angle = WMath.modulo2PI(angle);
			if (angle > Math.PI) {
				angle -= Math.PI * 2;
			}
			return angle;
		}
	}
}


