/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pDi5
 */






package 
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.text.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.*;
    import org.papervision3d.cameras.*;
    import org.papervision3d.materials.special.Letter3DMaterial;
    import org.papervision3d.typography.fonts.HelveticaBold;
    import org.papervision3d.typography.Text3D;
    import caurina.transitions.properties.CurveModifiers;
    import caurina.transitions.Tweener;
    
    [SWF(width = "640", height = "200", frameRate = "60", backgroundColor = "0")]
    
    public class Main extends BasicView 
    {
        public function Main():void 
        {
            CurveModifiers.init()
            stage.quality = StageQuality.MEDIUM;
             motion();
            stage.addEventListener(MouseEvent.CLICK, motion);
            startRendering();
        }
        
        private function motion(e:Event = null):void
        {
            // create letter
            var text:TextField = new TextField(); 
            text.htmlText = "<font face='Dotum'>I AM BRAD SEDITO.\nHello, World.</font>";
            text.autoSize = "left";
            var cap:BitmapData = new BitmapData(text.textWidth  , text.textHeight , true, 0xFFFFFFFF);
            cap.draw(text);
            //addChild(new Bitmap(cap))
            
            var wrap:DisplayObject3D = scene.addChild(new DisplayObject3D());
            
            // particle motion
            var cnt:int = 0;
            for (var i:int = 0; i < text.textWidth; i++ )
            {
                for (var j:int = 0; j < text.textHeight; j++ )
                {
                    if (cap.getPixel(i, j) == 0xFFFFFF) continue;
                    
                    // A-Z
                    var char:String = String.fromCharCode(65 + 25 * Math.random() | 0);
                    
                    // letter
                    var lettermat:Letter3DMaterial = new Letter3DMaterial();
                    lettermat.fillColor = 0x000000;
                    var word:Text3D = new Text3D(char , new HelveticaBold() , lettermat);
                    
                    word.x = 1000 * Math.random() - 500 - 500;
                    word.y = 1000 * Math.random() - 500;
                    word.z = -5000;
                    word.scale = 2;
                    word.rotationZ = 720 * Math.random();
                    wrap.addChild(word);
                    
                    Tweener.addTween(word,
                    {
                        x : (i - text.textWidth / 2) * 30,
                        y : (text.textHeight / 2 - j) * 30,
                        z : 0,
                        scale : 0.5,
                        rotationZ: 0,
                        _bezier : [{x : 1000, y : 500}],
                        time : 3,
                        transition : "easeOutExpo",
                        delay : cnt++ * 0.0075
                    });
                }
            }
            
            // wrap motion
            wrap.z = 3000;
            Tweener.addTween(wrap,
            {
                z : -1000,
                time : 15,
                transition : "easeInExpo",
                onComplete : function():void
                {
                    scene.removeChild(wrap);
                } 
            });
            
            //word motion w/ wrap motion:            
/*                    Tweener.addTween(word,
                    {
                        z : Math.random()*1000,
                        scale : 0.5,
                        rotationZ: 0,
                        _bezier : [{x : 1000, y : 500}],
                        time : 10,
                        transition : "easeOutExpo", 
                        delay : cnt++ * 0.0075
                    });
*/            
            // camera motion
            camera.x = 0
            Tweener.addTween(camera,
            {
                x : 0,
                time : 20,
                transition : "easeInExpo"
            });
        }
        
    }
}