/**
 * Copyright rickyhk ( http://wonderfl.net/user/rickyhk )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pDAn
 */

// forked from kaikoga's int, uint, Number, String の比較による処理速度の違い
// forked from kaikoga's forked from: [最適化 Tips] Number, int, uint の計算による処理速度の違い
// forked from tail_y's forked from: [最適化 Tips] Number, int, uint の計算による処理速度の違い
// forked from muta244's [最適化 Tips] Number, int, uint の計算による処理速度の違い
package {

import flash.display.*;
import flash.geom.*;
import flash.events.*;
import flash.text.*;
import flash.utils.*;

public class Main extends Sprite
{
    static private const _NUM_TIMES:int = 1000000;
    
    private function _init():void
    {
        _debug(
            "各テスト " + _NUM_TIMES + " 回処理させた計算結果 [単位 ： ミリ秒]\n" +
            "(誤差は多少生じます)\n"
        );
        
        
        _measure("ループのみ", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
            }
        });
        
        _measure("int と int の比較", function ():void
        {
            var i1:int = 0;
            var i2:int = 0;
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:Boolean = (i1 == i2);
            }
        });
        
        _measure("uint と uint の比較", function ():void
        {
            var i1:uint = 0;
            var i2:uint = 0;
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:Boolean = (i1 == i2);
            }
        });
        
        _measure("Number と Number の比較", function ():void
        {
            var i1:Number = 2.5;
            var i2:Number = 2.5;
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:Boolean = (i1 == i2);
            }
        });
        
        _measure("String と String の比較（1文字一致）", function ():void
        {
            var s1:String = "a";
            var s2:String = "a";
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:Boolean = (s1 == s2);
            }
        });
        
        _measure("String と String の比較（1文字不一致）", function ():void
        {
            var s1:String = "a";
            var s2:String = "s";
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:Boolean = (s1 == s2);
            }
        });
        
        _measure("String と String の比較（10文字一致）", function ():void
        {
            var s1:String = "hogehogeho";
            var s2:String = "hogehogeho";
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:Boolean = (s1 == s2);
            }
        });
        
        _measure("String と String の比較（10文字不一致）", function ():void
        {
            var s1:String = "hogehogeho";
            var s2:String = "hogehogeh0";
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:Boolean = (s1 == s2);
            }
        });
        
        _measure("String と String の比較（10文字一致：動的生成）", function ():void
        {
            var s1:String = "hogehoge" + "ho";
            var s2:String = "hogehogeho";
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:Boolean = (s1 == s2);
            }
        });
        
        _measure("String と String の比較（10文字不一致：動的生成）", function ():void
        {
            var s1:String = "hogehoge" + "h0";
            var s2:String = "hogehogeho";
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:Boolean = (s1 == s2);
            }
        });
        
        _measure("String と String の比較（10文字不一致：動的生成）", function ():void
        {
            var s1:String = "aogehoge" + "h0";
            var s2:String = "hogehogeho";
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:Boolean = (s1 == s2);
            }
        });
        
        _measure("String と String の比較（100文字一致）", function ():void
        {
            var s1:String = "0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789";
            var s2:String = "0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789";
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:Boolean = (s1 == s2);
            }
        });
        
        _measure("String と String の比較（100文字先頭不一致）", function ():void
        {
            var s1:String = "0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789";
            var s2:String = "o123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789";
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:Boolean = (s1 == s2);
            }
        });
        
        _measure("String と String の比較（100文字不一致）", function ():void
        {
            var s1:String = "0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789";
            var s2:String = "0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456780";
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:Boolean = (s1 == s2);
            }
        });
        
        _measure("String と String の比較（100文字一致：動的生成）", function ():void
        {
            var s1:String = "aaaaaaaaaa".replace(/a/g, "0123456789");
            var s2:String = "bbbbb".replace(/b/g, "01234567890123456789");
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:Boolean = (s1 == s2);
            }
            
        });
        
        _measure("String と String の比較（100文字先頭不一致：動的生成）", function ():void
        {
            var s1:String = "o123456789aaaaaaaaa".replace(/a/g, "0123456789");
            var s2:String = "bbbbb".replace(/b/g, "01234567890123456789");
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:Boolean = (s1 == s2);
            }
        });
        
        _measure("String と String の比較（100文字不一致：動的生成）", function ():void
        {
            var s1:String = "aaaaaaaaa0123456788".replace(/a/g, "0123456789");
            var s2:String = "bbbbb".replace(/b/g, "01234567890123456789");
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:Boolean = (s1 == s2);
            }
        });
        
        
        _debug("\n結果については言及しませんので, 各自ご判断ください.");
    }
    
    private var _field:TextField;
    private var _time:uint;
    
    public function Main():void
    {
        _setup();
        _init();
    }
    
    private function _measure(title:String, func:Function, ...params):void
    {
        _time = getTimer();
        func.apply(null, params);
        _time = getTimer() - _time;

        _debug("[ " + title + " ] --> " + _time + " ms");
    }
    
    private function _debug(log:String):void
    {
        _field.appendText(log + "\n");
    }
    
    private function _setup():void
    {
        _field = new TextField();
        _field.width = stage.stageWidth - 40;
        _field.height = stage.stageHeight - 60;
        _field.x = 20;
        _field.y = 60;
        _field.multiline = true;
        _field.wordWrap = true;
        
        var format:TextFormat = _field.defaultTextFormat;
        format.font = "_sans";
        _field.defaultTextFormat = format;
        
        addChild(_field);
        
        var button:Sprite = new Sprite();
        button.graphics.lineStyle(1, 0xBBBBBB);
        button.graphics.beginFill(0xEEEEEE);
        button.graphics.drawRoundRect(0, 0, 100, 20, 5, 5);
        button.graphics.endFill();
        
        addChild(button);
        
        button.x = 20;
        button.y = 20;
        button.mouseChildren = false;
        button.buttonMode = true;
        
        var field:TextField = new TextField();
        field.width = 100;
        field.height = 20;
        field.htmlText = "<p align='center'><font face='_sans'>再計算</span></p>";
        
        button.addChild(field);
        
        button.addEventListener(MouseEvent.CLICK, function ():void
        {
            _field.text = "";
            _init();
        });
    }
}

}
