/**
 * Copyright yonatan ( http://wonderfl.net/user/yonatan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pBIN
 */

// forked from yonatan's flash on 2009-4-28
package {
    import flash.events.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.utils.*;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.*
    import org.papervision3d.view.*;
    import org.papervision3d.core.math.Number3D;
    import org.papervision3d.core.geom.renderables.*;
    
    import caurina.transitions.Tweener;

    public class Main extends BasicView {
        private var cube      :Cube;
        private var materials :MaterialsList;
        private var light:PointLight3D;
        private var updateNormals:Boolean
        
        public function Main() {
            stage.quality = "medium";
            
            light = new PointLight3D(false);
            light.x = 0;
            light.y = 0;
            light.z = -1000;
            materials = new MaterialsList( { all : new FlatShadeMaterial(light, 0xD7261C ) } );            
            cube = new Cube( materials, 500, 500, 500, 5, 5, 5 );
            scene.addChild( cube );
            addEventListener( Event.ENTER_FRAME, onEnterFrame );
            stage.addEventListener( MouseEvent.CLICK, onClick );
        }
        
        public function onClick(e:MouseEvent): void {
            var vertices:Array = cube.geometry.vertices;
            var x:Number, y:Number, z:Number, len:Number;
            
            for each( var v:Vertex3D in vertices ) {
                x = v.x; y = v.y; z = v.z;
                len = Math.sqrt(x*x+y*y+z*z) / 400;
                x /= len;
                y /= len;
                z /= len;
                Tweener.addTween( v, {x: x, y: y, z: z, time: 4, transition: "linear"} );
            }

            for each( var face:Triangle3D in cube.geometry.faces ) {
                var fn:Number3D = new Number3D(0,0,0);
                fn.plusEq(face.v0.toNumber3D());
                fn.plusEq(face.v1.toNumber3D());
                fn.plusEq(face.v2.toNumber3D());
                fn.normalize();
                Tweener.addTween( face.faceNormal, {x: fn.x, y: fn.y, z: fn.z, time: 4, transition: "linear"} );
            }
        }
        
        public function onEnterFrame(e:Event): void {
            cube.rotationY++;
            renderer.renderScene( scene, camera, viewport );
        }
    }
}