/**
 * Copyright mmlemon_ ( http://wonderfl.net/user/mmlemon_ )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pB2v
 */

/**
 * Copyright mmlemon_ ( http://wonderfl.net/user/mmlemon_ )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/d1yk
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.BlendMode;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    
    [SWF(backgroundColor=0x000000,frameRate=60)]
    import flash.filters.BlurFilter;
    public class FlashTest extends Sprite {
    		
    		private static const ITEMS:int = 100;
    		
    		private var m_mainContainer:Sprite;
    		private var m_additionalContainer:Sprite;
    		private var m_items:Vector.<Ball>;
    		private var m_timer:Timer;
    		
    		private var m_ball:RotateBall;
    		
        public function FlashTest() {
            // write as3 code here..
            
            graphics.beginFill(0x000000, 1);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            addEventListener(Event.ADDED_TO_STAGE, init, false, 0, false);
        }
        
        private function init(event:Event=null):void
        {
        		m_mainContainer = new Sprite();
        		m_mainContainer.blendMode = BlendMode.ADD;
        		addChild(m_mainContainer);
        		
        		m_additionalContainer = new Sprite();
        		addChild(m_additionalContainer);
        		//filters = [new BlurFilter(4, 8)];
        		initObj();
        		
        		addEventListener(Event.ENTER_FRAME, enterFrameHandler, false, 0, false);
        }
        
        private function initObj():void
        {
        		m_items = new Vector.<Ball>(ITEMS, true);
        		m_timer = new Timer(500, ITEMS);
        		m_timer.addEventListener(TimerEvent.TIMER, genBall, false, 0, false);
        		m_timer.start();
        		
        		m_ball = new RotateBall(0x0000ff, 10);
        		m_additionalContainer.addChild(m_ball);
        		m_ball.x = stage.stageWidth/2;
        		m_ball.y = stage.stageHeight/2;
        }
        
        private function genBall(event:TimerEvent):void
        {
        		var ball:Ball = new Ball(AppUtil.getRandomRed());
        		m_mainContainer.addChild(ball);
        		ball.x = stage.stageWidth/2;        		
        		ball.y = stage.stageHeight/2;        				
        		m_items[m_timer.currentCount-1] = ball;
        }
        
        private function enterFrameHandler(event:Event):void
        {
        		update();
        		draw();
        }
        
        private function update():void
        {
        		for(var i:int = 0; i < m_items.length; i++)
        		{
        			var ball:Ball = m_items[i];
        			if(ball!=null)
	        			ball.update();
        		}
        		if(m_ball!=null)
        		{
        			m_ball.update();
        		}
        }
   		private function draw(): void
   		{
   			
   		}
    }
}
import flash.display.Sprite;
class Ball extends Sprite{
	protected var m_col:uint;
	protected var m_rad:Number;
	
	public var vx:Number = 0;
	public var vy:Number = 0;
	public var vz:Number = 0;     	
	
	public function Ball(_col:uint=0xffffff,_rad:Number=10)    	{
		m_col = _col;
		m_rad = _rad * Math.random() * 1;
		graphics.beginFill(m_col);		graphics.drawCircle(-m_rad/2, -m_rad/2, m_rad);		graphics.endFill();
	
		init();
	}
	
	protected function init():void
	{
		vx = Math.random() * 1 - 0.5;
		vy = Math.random() * 1 - 0.5;
		vz = Math.random() * 1 - 0.5;
	}
	
	public function update():void
	{
		x += vx;
		y += vy;
		z += vz;
		
		vx *= 1.05;
		vy *= 1.05;
		vz *= 1.05;
	
		restart();
	}
	
	public function restart():void
	{
		if(x < -m_rad || x > stage.stageWidth + m_rad		|| y < m_rad || y > stage.stageHeight + m_rad)		{			vx = Math.random() * 1 - 0.5;
			vy = Math.random() * 1 - 0.5;
			vz = Math.random() * 1 - 0.5;
			
			x = stage.stageWidth/2;
			y = stage.stageHeight/2;
			z = 0;
		}
	}
}

class RotateBall extends Ball
{
	private var m_r:Number;
	private var m_vr:Number;
	
	private var m_addX:Number;
	private var m_addY:Number;
	private var m_vz:Number;
	public function RotateBall(_col:uint=0xffffff,_rad:Number=10)
	{
		super(_col, _rad);
		m_r = 0;
		m_vr = Math.PI / 180 * 5;
		m_rad = Math.random()*5 + 10;
		m_addX = Math.random() * 5-2.5;
		m_addY = Math.random() * 5-2.5;
		m_vz = Math.random() * 5 * -1;
	}
	
	override public function update():void
	{
		//m_vr *= 1.01;
		m_r += m_vr;
		x = Math.cos(m_r) * m_rad + stage.stageWidth/2;
		y = Math.sin(m_r) * m_rad + stage.stageHeight/2;
		z += m_vz;
		m_vz *= 1.01;
		x += m_addX;
		//y += m_addY;
		m_rad += 0.1;
		restart();
	}

	override public function restart():void
	{		if(x < -m_rad || x > stage.stageWidth + m_rad	
	|| y < m_rad || y > stage.stageHeight + m_rad || z < -500)
		{			
			vx = Math.random() * 1 - 0.5;			m_r = 0;			x = stage.stageWidth/2;			y = stage.stageHeight/2;			z = 0;
			m_vz = 1;
			m_vr = Math.PI / 180 * 5;			m_rad = Math.random()*5 + 10;			m_addX = Math.random() * 50-25;			m_addY = Math.random() * 50-25;			m_vz = Math.random() * 5 * -1;		}
	}
}

class AppUtil
{
	public static function getRandomColor():uint
	{
		return 0xff*Math.random() << 16 | 0xff*Math.random() << 8 | 0xff*Math.random();
	}
	
	public static function getRandomRed():uint
	{
		return (0x33*Math.random() + 0xcc) << 16;
	}
}