/**
 * Copyright demouth ( http://wonderfl.net/user/demouth )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pAiw
 */

// forked from egyu2's 一筆書き（鉛筆風）
/**
 * 一筆書きで画像を書く。
 * 起動後1、2秒くらい座標計算します。
 * 画像の埋め込みはclockmakerさんのクラスを使用させていただきました。
 * http://wonderfl.kayac.com/code/cf21d213336193c264cd1e2e6031615609603ce2
 */
package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BitmapDataChannel;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.net.URLRequest;
	import flash.text.TextField;
	
	public class Main extends Sprite 
	{
		
		private var image:Bitmap;
		private var processingText:TextField;
		private var v:Vector.<Point> = new Vector.<Point>();
		private const DATA:String = "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"
		private var loader:Loader;
		private const SCALE:Number = 3.1;
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			Wonderfl.capture_delay( 100 );
			this.loader = Base64ImageLoader.load(this.DATA) as Loader;
			
			this.processingText = new TextField();
			this.processingText.htmlText = "<font size='14'>座標計算中</font>";
			this.addChild(this.processingText);
			
			this.loader.addEventListener(Event.ADDED , this.onLoad );
		}
		
		private function onLoad(event:Event):void
		{
			this.removeChild(this.processingText);
			this.image = (this.loader).content as Bitmap;
			this.addChild(this.image);
			
			this.checkColor();
			this.v = this.sort();
			var d:Drawer = new Drawer(this.v , this.image.width , this.image.height, this.SCALE);
			this.addChild(d);
			this.image.scaleX = this.image.scaleY = this.SCALE;
			this.image.alpha = 0.15;
		}
		
		/**
		 * 描画するドットを決定
		 */
		private function checkColor():void
		{
			var w:uint = this.image.width;
			var h:uint = this.image.height;
			var r:uint = 0;
			var g:uint = 0;
			var b:uint = 0;
			
			for (var i:int = 0; i < h; i++) 
			{
				for (var j:int = 0; j < w; j++) 
				{
					var color:uint = this.image.bitmapData.getPixel(j, i);
					r = ( color >> 16 ) & 0xFF;
					g = ( color >> 8 ) & 0xFF;
					b = ( color ) & 0xFF;
					if ( (r + g + b) < 10 )this.v.push(new Point(j, i));//閾値以下なら描画用の座標に格納
				}
			}
		}
		
		private function sort():Vector.<Point>
		{
			var length:int = this.v.length;
			var tmp:Vector.<Point> = new Vector.<Point>();
			var nowPoint:Point = new Point();
			for (var i:int = 0; i < length; i++) 
			{
				var num:int = this.check(nowPoint);
				nowPoint = this.v[num];
				tmp.push(this.v.splice(num, 1)[0]);
			}
			return tmp;
		}
		
		/**
		 * 一番近いドットを決定
		 */
		private function check(p:Point):int
		{
			var near:uint;
			var nearDiff:int;
			var length:uint = this.v.length;
			
			var diffX:int = 0;
			var diffY:int = 0;
			var diff:int = 0;
			for (var i:int = 0; i < length; i++) 
			{
				diffX = this.v[i].x - p.x;
				diffY = this.v[i].y - p.y;
				diff = Math.sqrt((diffX * diffX) + (diffY * diffY));
				
				if (diff < nearDiff || (i == 0))
				{
					nearDiff = diff;
					near = i;
				}
			}
			return near;
		}
		
	}
	
}
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.events.Event;
import flash.geom.Point;
class Drawer extends Sprite
{
	private var v:Vector.<Point>;
	private var bitmap:Bitmap;
	private var brush:Sprite;
	private var w:Number;
	private var h:Number;
	private var num:int = 0;
	private var vX:Number = 0;
	private var vY:Number = 0;
	private var scale:Number = 1;
	private const ZATSU:Number = 10;//雑具合。高いと雑になる。
	
	public function Drawer(v:Vector.<Point> , w:Number , h:Number , scale:Number) 
	{
		this.v = v;//座標
		this.w = w;//画像の幅
		this.h = h;//画像の高さ
		this.scale = scale;//描画するサイズ
		this.init();
	}
	
	private function init():void
	{
		var bitmapData:BitmapData = new BitmapData(this.w*this.scale, this.h*this.scale, true,0x00000000);
		this.bitmap = new Bitmap(bitmapData);
		this.addChild(this.bitmap);
		
		this.brush = new Sprite();
		this.addChild(this.brush);
		this.brush.graphics.beginFill(0, 1);
		this.brush.graphics.drawCircle(0,0,2);
		this.brush.graphics.endFill();
		
		var length:int = this.v.length;
		for (var i:int = 0; i < length; i++) 
		{
			this.v[i].x *= this.scale;
			this.v[i].y *= this.scale;
		}
		
		this.addEventListener(Event.ENTER_FRAME , onEnterFrame);
	}
	
	private function onEnterFrame(event:Event):void
	{
		if(this.num < this.v.length){
			var p:Point = this.v[this.num];
			this.vX += (p.x - this.brush.x) * 0.1;
			this.vY += (p.y - this.brush.y) * 0.1;
			this.vX *= 0.85;
			this.vY *= 0.85;
			this.brush.x += this.vX;
			this.brush.y += this.vY;
			this.bitmap.bitmapData.draw(this);
			var diffX:int = p.x - this.brush.x;
			var diffY:int = p.y - this.brush.y;
			var diff:Number = Math.sqrt((diffX * diffX) + (diffY * diffY));
			if(diff < this.ZATSU)this.num++;
		} else {
			this.removeEventListener(Event.ENTER_FRAME , onEnterFrame);
		}
	}
	
}

/**
 * Base64化された画像データを表示可能な形式に変換するクラス
 * 
 * 使い方 :
 * var data:String = "Base64化された画像データ";
 * var display:DisplayObjectContainer = Base64ImageLoader.load(data);
 * if (display != null)
 *     addChild(display);
 */
class Base64ImageLoader
{
	import flash.display.DisplayObjectContainer;
	import flash.display.Loader;
	import flash.utils.ByteArray;
	import mx.utils.Base64Decoder;
	static public function load(data:String):DisplayObjectContainer
	{
		var byteArray:ByteArray;
		var base64Decoder:Base64Decoder;
		var loader:Loader;
		
		base64Decoder = new Base64Decoder();
		base64Decoder.decode(data);
		
		try {
			byteArray = base64Decoder.toByteArray();
			byteArray.position = 0;
		} catch (e:Error) {
			return null;
		}
		
		loader = new Loader();
		loader.loadBytes(byteArray);
		
		return loader;
	}
}