/**
 * Copyright ladeng6666 ( http://wonderfl.net/user/ladeng6666 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pALZ
 */

package  
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.utils.getTimer;
    
    /**
     * ...
     * @author ladeng6666
     */
    public class Main extends Sprite
    {
        private const DURATION:Number = 3;
        private const EASE_ARRAY:Array = [AllEase.Back, AllEase.Bounce, AllEase.Circ, AllEase.Cubic, AllEase.Elastic, AllEase.Line];
        private const EASE_NAME:Array = ["Back","Bounce","Circ","Cubic","Elastic","Line"];
        private var rectWidth:int;
        private var rectHeight:int;
        
        private var moveSprite:Sprite;
        private var flag:Sprite;
        private var tweenLine:Sprite;
        private var easeText:TextField;
        
        private var factor:Number;
        
        private var time_start:Number;
        private var ease:Function;
        private var ease_index:int = 0;
        
        public function Main() 
        {
            init();
            drawBG();
            drawTweenLine();
        }
        private function init():void
        {
            time_start = getTimer();
            ease = EASE_ARRAY[ease_index];
            
            moveSprite = createRect(50, 50, 0xffcc00);
            moveSprite.x = 50;
            moveSprite.y = 50;
            addChild(moveSprite);
            
            flag = createRect(5, 5, 0xff0000);
            flag.x = 50;
            flag.y = 200;
            addChild(flag);
            
            tweenLine = new Sprite();
            addChild(tweenLine);
            
            addEventListener(Event.ENTER_FRAME, loop);
            stage.addEventListener(MouseEvent.CLICK, onClick);
            
        }
        private function drawBG():void
        {
            rectWidth = stage.stageWidth - 100;
            rectHeight = 150;
            
            var bg:Sprite = new Sprite();
            addChild(bg);
            with (bg){
                graphics.lineStyle(2);
                graphics.drawRect(50, 50, rectWidth, 50);
                graphics.endFill();
                
                graphics.drawRect(50, 200, rectWidth, rectHeight);
                graphics.endFill();
            }
            var time_text:TextField = new TextField();
            time_text.text = "time";
            time_text.x = stage.stageWidth - 100;
            time_text.y = 352;
            addChild(time_text);
            var factor_text:TextField = new TextField();
            factor_text.text = "factor";
            factor_text.y = 200;
            addChild(factor_text);
            
            var txtFormat:TextFormat = new TextFormat("Impact", 30);
            easeText = new TextField();
            easeText.defaultTextFormat = txtFormat;
            easeText.text = EASE_NAME[0];
            easeText.x = stage.stageWidth / 2;
            easeText.y = 120;
            addChild(easeText);
        }
        private function drawTweenLine():void
        {
            
            var f:Number = 0;
            tweenLine.graphics.clear();
            tweenLine.graphics.lineStyle(2, 0xff0000);
            tweenLine.graphics.moveTo(50, 200 + rectHeight);
            
            for (var x:Number = 50; x < 50+rectWidth; x++) {
                f = ease(x-50, 0, 1, rectWidth);
                tweenLine.graphics.lineTo(x, 200+rectHeight * (1-f));
            }
            tweenLine.graphics.endFill();
        }
        private function createRect(w:Number, h:Number,c:Number):Sprite
        {
            var s:Sprite = new Sprite();
            s.graphics.lineStyle(1);
            s.graphics.beginFill(c);
            s.graphics.drawRect(0, 0, w, h);
            s.graphics.endFill();
            
            return s;
        }

        private function loop(e:Event):void
        {
            var flagX:Number;
            var time:Number = (getTimer() - time_start) / 1000;
            if (time >= DURATION ) {
                time = DURATION;
            }
            flagX = time / DURATION * rectWidth + 50;
            
            factor = ease(time, 0, 1, DURATION);

            moveSprite.x = 50 + (rectWidth - 50) * factor;
            flag.y = 200 + rectHeight * (1 - factor);
            
            graphics.clear();
            graphics.lineStyle(1);
            graphics.moveTo(flagX, 200 + rectHeight);
            graphics.lineTo(flagX, 200);
            graphics.moveTo(50, flag.y);
            graphics.lineTo(50 + rectWidth, flag.y);

            
        }
        private function reStart():void
        {
            time_start = getTimer();
        }
        private function onClick(me:MouseEvent):void {
            if (ease_index < EASE_ARRAY.length-1) {
                ease_index++;
            }else {
                ease_index = 0;
            }
            ease = EASE_ARRAY[ease_index];
            easeText.text = EASE_NAME[ease_index];
            drawTweenLine();
            reStart();
        }
    }
}
class AllEase {
    private static const _2PI:Number = Math.PI * 2;
    public static function Back (t:Number, b:Number, c:Number, d:Number, s:Number = 1.70158):Number {
        return c*(t/=d)*t*((s+1)*t - s) + b;
    }
    public static function Line (t:Number, b:Number, c:Number, d:Number):Number {
        return c*t/d + b;
    }
    public static function Bounce (t:Number, b:Number, c:Number, d:Number):Number {
        if ((t/=d) < (1/2.75)) {
            return c*(7.5625*t*t) + b;
        } else if (t < (2/2.75)) {
            return c*(7.5625*(t-=(1.5/2.75))*t + .75) + b;
        } else if (t < (2.5/2.75)) {
            return c*(7.5625*(t-=(2.25/2.75))*t + .9375) + b;
        } else {
            return c*(7.5625*(t-=(2.625/2.75))*t + .984375) + b;
        }
    }
    public static function Circ (t:Number, b:Number, c:Number, d:Number):Number {
        return -c * (Math.sqrt(1 - (t/=d)*t) - 1) + b;
    }
    public static function Cubic (t:Number, b:Number, c:Number, d:Number):Number {
        return c*(t/=d)*t*t + b;
    }
    public static function Elastic (t:Number, b:Number, c:Number, d:Number, a:Number = 0, p:Number = 0):Number {
        var s:Number;
        if (t==0) return b;  if ((t/=d)==1) return b+c;  if (!p) p=d*.3;
        if (!a || a < Math.abs(c)) { a=c; s = p/4; }
        else s = p/_2PI * Math.asin (c/a);
        return -(a*Math.pow(2,10*(t-=1)) * Math.sin( (t*d-s)*_2PI/p )) + b;
    }
}
