/**
 * Copyright nicotroia ( http://wonderfl.net/user/nicotroia )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/p9br
 */

package {

    import flash.events.Event;
    import flash.geom.Point;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    
    public class NoiseTest extends Sprite { 
    
        private var _offsets:Array = [];
        private var _speeds:Array = [];
        private var _numOctaves:uint = 4;
        private var _bitmapData:BitmapData;
        
        public function NoiseTest() {
            var bgColor:Bitmap = new Bitmap(new BitmapData(500, 500, true, 0xFF0099ff));
            addChild(bgColor);
            
            _bitmapData = new BitmapData(500, 500, true);
            var bitmap:Bitmap = new Bitmap(_bitmapData);
            addChild(bitmap);
            
            for( var o:uint = 0; o < _numOctaves; o++ ){
                _offsets[o] = new Point(0,0);
            }
            
            _speeds[0] = new Point(-1.2,-0.4); 
            _speeds[1] = new Point(-1.8,1.3); 
            _speeds[2] = new Point(2.8,0.6); 
            _speeds[3] = new Point(1,1); 
            
            stage.addEventListener(Event.ENTER_FRAME, animate);
        }        

        private function animate(e:Event):void {
            for( var o:uint = 0; o < _numOctaves; o++ ){
                _offsets[o].x += _speeds[o].x;
                _offsets[o].y += _speeds[o].y;
            }

            _bitmapData.perlinNoise(122, 12, _numOctaves, 0, false, true, 15, true, _offsets);
        }
    }

}