/**
 * Copyright curvedstraightline ( http://wonderfl.net/user/curvedstraightline )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/p7k3
 */

package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    /**
     * ...
     * @author curved straight line
     */
    [SWF(backgroundColor="0xEEEEEE",frameRate="40")]
    public class Main extends Sprite 
    {
        private var mouseLocus:Array = new Array();
        private var canvas_bmd:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0xeeeeee);
        private var canvas:Bitmap = new Bitmap(canvas_bmd);
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            addChild(canvas);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, mouseUp);
        }
        
        private function mouseDown(me:MouseEvent):void
        {
            //trace("yes")
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            mouseLocus.unshift(mouseX);
            mouseLocus.unshift(mouseY);
        }
        private function onEnterFrame(e:Event):void
        {
            mouseLocus.unshift(mouseX);
            mouseLocus.unshift(mouseY);
            var size:int;
            var thickness:Number;
            var width:int = Math.abs(mouseLocus[0] - mouseLocus[2]);
            var height:int = Math.abs(mouseLocus[1] - mouseLocus[3]);
            size = (width + height) * 0.35;
            thickness = (width + height) * 0.05;
            //trace(size);
            var circle:Circle = new Circle(mouseX, mouseY, size, thickness);
            canvas_bmd.draw(circle);
        }
        
        private function mouseUp(me:MouseEvent):void
        {
            //trace("no");
            removeEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
    }
    
}

import flash.display.Shape;
import flash.display.Sprite;
class Circle extends Sprite
{
    private var c:Shape;
    public function Circle(x:int,y:int,size:int,thickness:Number):void
    {
        c = new Shape();
        c.graphics.beginFill(0xffffff);
        c.graphics.lineStyle(thickness, 0x000000);
        c.graphics.drawCircle(x, y, size);
        c.graphics.endFill();
        this.addChild(c);
        //trace("yes");
    }
}