/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/p7Xw
 */

package {
  import flash.display.Sprite;
  import flash.events.*;
  import flash.geom.*;
  import flash.text.*;
  import flash.ui.Keyboard;
  public class ch15ex5 extends Sprite {
    protected var tf:TextField;
    public function ch15ex5() {
      var cube:Cube = new Cube(100); addChild(cube);
      cube.x = stage.stageWidth * 0.5; cube.y = stage.stageHeight * 0.5;
      cube = new Cube(100); addChild(cube);
      cube.rotationX = -40; cube.rotationY = 20; cube.rotationZ = 12;
      cube.x = stage.stageWidth * 0.2; cube.y = stage.stageHeight * 0.6;
      cube.z = 250;
      cube = new Cube(100); addChild(cube);
      cube.rotationX = 95; cube.rotationY = -30; cube.rotationZ = 12;
      cube.x = stage.stageWidth * 0.7; cube.y = stage.stageHeight * 0.4;
      cube.z = -250;
      tf = new TextField(); tf.height = 14; tf.x = tf.y = 5;
      tf.autoSize = TextFieldAutoSize.LEFT;
      tf.backgroundColor = 0; tf.background = true;
      tf.defaultTextFormat = new TextFormat("_typewriter", 10, 0xffffff);
      addChild(tf);
      stage.addEventListener(MouseEvent.MOUSE_WHEEL, onMouseWheel);
      stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
      stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
    }
    protected function onMouseMove(event:MouseEvent):void {
      var pp:PerspectiveProjection = root.transform.perspectiveProjection;
      pp.projectionCenter = new Point(event.stageX, event.stageY);
      update(pp);
    }
    protected function onMouseWheel(event:MouseEvent):void {
      adjustFov(event.delta / 2);
    }
    protected function onKeyDown(event:KeyboardEvent):void {
      switch (event.keyCode) {
        case Keyboard.UP: case Keyboard.PAGE_UP: adjustFov(4); break;
        case Keyboard.DOWN: case Keyboard.PAGE_DOWN: adjustFov(-4); break;
      }
    }
    protected function adjustFov(delta:Number): void {
      var pp:PerspectiveProjection = root.transform.perspectiveProjection;
      var fov:Number = pp.fieldOfView + delta;
      fov = Math.min(Math.max(1, fov), 179);
      pp.fieldOfView = fov;
      update(pp);
    }
    protected function update(pp:PerspectiveProjection):void {
      //set the projection
      stage.transform.perspectiveProjection = pp;
      
      var ctr:Point = pp.projectionCenter;
      var BR:Point = new Point(stage.stageWidth, stage.stageHeight);
      graphics.clear();
      graphics.lineStyle(0, 0, 0.2);
      graphics.moveTo(0, 0); graphics.lineTo(ctr.x, ctr.y);
      graphics.moveTo(BR.x, 0); graphics.lineTo(ctr.x, ctr.y);
      graphics.moveTo(0, BR.y); graphics.lineTo(ctr.x, ctr.y);
      graphics.moveTo(BR.x, BR.y); graphics.lineTo(ctr.x, ctr.y);
      tf.text = "vanish (" + ctr.x.toFixed() + ", " + ctr.y.toFixed() + ")  " +
        "FOV=" + pp.fieldOfView.toFixed(1) + "°";
    }
  }
}
import flash.display.*;
class Cube extends Sprite {
  public function Cube(size:Number = 50) {
    for (var side:int = 0; side < 6; side++) {
      var face:Sprite = new Sprite();
      face.blendMode = BlendMode.MULTIPLY;
      var brightness:int = 0x80 + 0x80 * Math.random();
      var color:int = brightness << 16 | brightness << 8 | brightness;
      face.graphics.beginFill(color, 0.8);
      face.graphics.drawRect(-size/2, -size/2, size, size);
      face.graphics.endFill();
      addChild(face);
    }
    var S2:Number = size/2;
    getChildAt(0).rotationY = 90; getChildAt(0).x = -S2;
    getChildAt(1).rotationY = -90; getChildAt(1).x = S2;
    getChildAt(2).z = -S2;
    getChildAt(3).rotationY = 180; getChildAt(3).z = S2;
    getChildAt(4).rotationX = 90; getChildAt(4).y = S2;
    getChildAt(5).rotationX = -90; getChildAt(5).y = -S2;
    addChild(new Axes());
  }
}
class Axes extends Sprite {
  public function Axes(size:Number = 20) {
    var s:Shape;
    s = new Shape(); addChild(s);
    s.graphics.lineStyle(4, 0x00ff00);
    s.graphics.moveTo(0, 0); s.graphics.lineTo(0, size);
    s = new Shape(); addChild(s);
    s.graphics.lineStyle(4, 0xff0000);
    s.graphics.moveTo(0, 0); s.graphics.lineTo(size, 0);
    s = new Shape(); addChild(s); s.rotationX = 90;
    s.graphics.lineStyle(4, 0x0000ff);
    s.graphics.moveTo(0, 0); s.graphics.lineTo(0, -size);
  }
}