/**
 * Copyright FTMSuperfly ( http://wonderfl.net/user/FTMSuperfly )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/p72K
 */

// forked from Keetapol.Boonprachak's forked from: CoverFlow step4
// forked from Keetapol.Boonprachak's CoverFlow step4
// forked from Keetapol.Boonprachak's CoverFlow step3
// forked from Keetapol.Boonprachak's CoverFlow step2
// forked from Keetapol.Boonprachak's CoverFlow step1
package 
{
    import flash.events.Event;
    import flash.display.Sprite;
    import com.bit101.components.PushButton;
    
    [SWF(frameRate="60",backgroundColor="0x000000")]
    public class CoverFlowVariable extends Sprite
    {
        public var coverflow:CoverFlow;
        public var button:PushButton;
        
        
        public function CoverFlowVariable()
        {
            button = new PushButton(this, 5, 5, "Switch", onButtonClick);
            addChild(button);

            coverflow = new CoverFlow(CoverFlow.VERTICAL, 20);
            addChild(coverflow);
        }
        
        public function onButtonClick(e:Event):void
        {
            if(contains(coverflow))
            {
                switch(coverflow.orientation)
                {
                    case CoverFlow.HORIZONTAL : 
                        removeChild(coverflow), coverflow = null;
                        coverflow = new CoverFlow(CoverFlow.VERTICAL, 20);
                        addChild(coverflow);
                        break;
                    case CoverFlow.VERTICAL : 
                        removeChild(coverflow), coverflow = null;
                        coverflow = new CoverFlow(CoverFlow.HORIZONTAL, 20);
                        addChild(coverflow);
                        break;
                }
            }
        }


    }
}




    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.events.Event;
    import flash.net.URLRequest;

    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import caurina.transitions.Tweener;
    import flash.geom.PerspectiveProjection;
    import flash.geom.Point;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import flash.system.Security;
 
    
    class CoverFlow extends Sprite 
    {
        
        public static var HORIZONTAL:String = "horizontal";
        public static var VERTICAL:String = "vertical";
        
        public var orientation:String;
         
        public var angleOffset:Number;
        
        private var dummy:XML = <data><item /><item /><item /><item /><item /><item /><item /><item /></data>;
        
        private var _container:Sprite;
        private var _items:Vector.<Item>;
        
        private var _currentIndex:int = 0;
        
        private var _prevButton:CoverFlowButton;
        private var _nextButton:CoverFlowButton;
       
        
        //=============================
        //  PUBLIC
        //=============================
        public function goto(index:uint):Boolean
        {
            if(index >= _items.length) return false;
            
            _currentIndex = index;
            update();
            return true;
        }
        
        public function previousItem():void
        {
            _currentIndex--;
            if (_currentIndex < 0) _currentIndex = _items.length - 1;
            update();
        }
        
        public function nextItem():void
        {
            _currentIndex++;
            if (_currentIndex >= _items.length) _currentIndex = 0;
            update();
        }
        
        
        
        
        
        
        
        public function CoverFlow(orientation:String, angleOffset:Number) 
        {
           this.orientation = orientation;
           this.angleOffset = angleOffset;
           
           if(stage) onAddedToStage(null);
           else addEventListener(Event.ADDED_TO_STAGE,onAddedToStage);    
        }
        
        private function onAddedToStage(e:Event):void
        {
            removeEventListener(Event.ADDED_TO_STAGE,onAddedToStage);
            
            stage.addEventListener(Event.RESIZE,onStageResize);
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
        
            Security.loadPolicyFile("http://photos.googleapis.com/data/crossdomain.xml");
            
            var ldr:URLLoader = new URLLoader();
            ldr.addEventListener(Event.COMPLETE,onLoadListingComplete);            
            ldr.load(new URLRequest("http://photos.googleapis.com/data/feed/base/all?alt=rss&kind=photo&q=sunset&max-results=50&imgmax=288"));
        }
        
        private function onLoadListingComplete(e:Event):void
        {            
            var rss:XML = new XML(e.target.data);
            
            build(rss.channel[0]);
            
            onStageResize(null);
        }
        
        private function onStageResize(e:Event):void
        {
            if(_container && stage)
            {
                _container.x = stage.stageWidth*0.5;
                _container.y = stage.stageHeight*0.5;
            }
        }
        
        private function build(data:XML):void
        {
            _container = new Sprite();
            addChild(_container);
            
            if(orientation == HORIZONTAL)
            {
                _prevButton = new CoverFlowButton(10, 50, 0xAAAAAA, 0.85, 3, 0xFFFFFF, 0.65);
                _nextButton = new CoverFlowButton(10, 50, 0xAAAAAA, 0.85, 3, 0xFFFFFF, 0.65);
            }
            else
            {
                _prevButton = new CoverFlowButton(50, 10, 0xAAAAAA, 0.85, 3, 0xFFFFFF, 0.65);
                _nextButton = new CoverFlowButton(50, 10, 0xAAAAAA, 0.85, 3, 0xFFFFFF, 0.65);
            }


            _prevButton.addEventListener(MouseEvent.CLICK, button_CLICK);
            _nextButton.addEventListener(MouseEvent.CLICK, button_CLICK);
            
            addChild(_prevButton);
            addChild(_nextButton);
            
            if(orientation == HORIZONTAL)
            {
                _prevButton.y = _nextButton.y = (465/2) - (_prevButton.height /2);
                _prevButton.x = 10;
                _nextButton.x = 465 - _nextButton.width - 10;
            }
            else
            {
                _prevButton.x = _nextButton.x = (465/2) - (_prevButton.width /2);
                _prevButton.y = 10;
                _nextButton.y = 465 - _nextButton.height - 10;
            }

            
            _items = new Vector.<Item>();
            
            for(var i:int = 0; i < data.item.length(); i++)
            {
                var item:Item = new Item(data.item[i]);
                _container.addChild(item);
                item.addEventListener(MouseEvent.CLICK,item_CLICK);
                _items.push(item);
            }
                        
            var pp:PerspectiveProjection = new PerspectiveProjection();
            pp.projectionCenter = new Point(0,0);
            _container.transform.perspectiveProjection = pp;

            update(0);
        }
        
        private function update(time:Number = 1):void
        {
            for(var i:int = 0; i < _items.length; i++)
            {
                var offset:int = (i - _currentIndex);
                var X:Number = 130 * offset;
                var Y:Number = 130 * offset;
                var Z:Number = 100 * Math.abs(offset);
                var RX:Number = 0;
                var RY:Number = 0;
                
                if (offset > 0)
                {
                    RX = -angleOffset;
                    RY = angleOffset;
                }
                else if (offset < 0)
                {
                    RX = angleOffset;
                    RY = -angleOffset;
                }
                
                var alphaOffsetSubtractor:Number;
                if (orientation == HORIZONTAL)
                {
                    alphaOffsetSubtractor = 0.2;
                }
                else if (orientation == VERTICAL)
                {
                    alphaOffsetSubtractor = 0.4;
                }
                var alphaOffset:Number = 1 - (Math.abs(offset) * alphaOffsetSubtractor);
                if (alphaOffset > 0) _items[i].visible = true;  
                
                if (orientation == HORIZONTAL)
                {
                    Tweener.addTween(_items[i],{
                        x:X,
                        z:Z,
                        rotationY:RY,
                        alpha:alphaOffset,
                        time:time,
                        onCompleteParams:[_items[i]],
                        onComplete:function(obj:Item):void {
                           if(obj.alpha < 0.1) obj.visible = false; 
                        }
                    });
                }
                else if (orientation == VERTICAL)
                {
                    Tweener.addTween(_items[i],{
                        y:Y,
                        z:Z,
                        rotationX:RX,
                        alpha:alphaOffset,
                        time:time,
                        onCompleteParams:[_items[i]],
                        onComplete:function(obj:Item):void {
                           if(obj.alpha < 0.1) obj.visible = false; 
                        }
                    });
                }
                
                
                var numRight:int = _items.length-_currentIndex-1;
                var num:int = (_currentIndex>numRight)?_currentIndex:numRight;
                _container.addChildAt(_items[i],num-Math.abs(offset));
            }
        }
        
        private function item_CLICK(e:MouseEvent):void
        {
            goto(_items.indexOf(e.currentTarget));
        }
        
        private function button_CLICK(e:MouseEvent):void
        {
            switch(e.currentTarget)
            {
                case _prevButton : previousItem(); break;
                case _nextButton : nextItem(); break;
            }
        }
        
    }




    class Item extends Sprite
    {
        private var media:Namespace = new Namespace("http://search.yahoo.com/mrss/");
        
        public function Item(xml:XML = null)
        {
            if(!xml)
            {
                var w:Number = 250;
                var h:Number = 200;
                graphics.beginFill((0xFFFFFF*0.6)+(0xFFFFFF*0.4)*Math.random());
                graphics.lineStyle(1,0x333333,1,true);
                graphics.drawRect(-w*0.5,-h*0.5,w,h);
                graphics.endFill();
            }
            else    
            {
                var url:String = xml.media::group.media::thumbnail[1].@url;
                var ldr:Loader = new Loader();
                ldr.contentLoaderInfo.addEventListener(Event.COMPLETE,onLoadComplete);
                ldr.load(new URLRequest(url));
                addChild(ldr);
            } 
        }
        
        private function onLoadComplete(e:Event):void
        {
            e.target.loader.x = -e.target.loader.width*0.5;
            e.target.loader.y = -e.target.loader.height*0.5;

            graphics.lineStyle(4,0xffffff,1,true,"normal","square","miter");
            graphics.drawRect(e.target.loader.x -2,e.target.loader.y -2,e.target.loader.width +4,e.target.loader.height +4);
        }

    }

    class CoverFlowButton extends Sprite
    {
        public function CoverFlowButton(w:Number = 20, h:Number = 20, colour:uint = 0xFF0000, alpha:Number = 1, lineThickness:Number = 1, lineColour:uint = 0xFF0000, lineAlpha:Number = 1, roundness:Number = NaN)
        {
            graphics.beginFill(colour, alpha);
            graphics.lineStyle(lineThickness, lineColour, lineAlpha, true);
            
            if (!isNaN(roundness)) graphics.drawRoundRect(0, 0, w, h, roundness);
            else graphics.drawRect(0, 0, w, h);
            
            graphics.endFill();
            buttonMode = true;
        }
    }



