/**
 * Copyright Aksor.Al1 ( http://wonderfl.net/user/Aksor.Al1 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/p6Su
 */

package {
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            // write as3 code here..
            
        }
    }
}
/*
.########..####.##....##..######...##.......########
.##.....##..##..###...##.##....##..##.......##......
.##.....##..##..####..##.##........##.......##......
.##.....##..##..##.##.##.##...####.##.......######..
.##.....##..##..##..####.##....##..##.......##......
.##.....##..##..##...###.##....##..##.......##......
.########..####.##....##..######...########.########
*/

/*--------------------------------------------------------------------------------------
 * Dingle MP3 Flash (AS3) Music player with realtime sound spectrum visualization
 * 
 * @version     Dingle Ver. 1.0
 * @author         TONG HAOWEN JOEL
 * @email         me [at] joeltong [dot] org
 * @website        http://www.joeltong.org/blog/
 * 
 *--------------------------------------------------------------------------------------
 * 
 * Copyright 2010 Tong Haowen Joel

 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at

 *   http://www.apache.org/licenses/LICENSE-2.0

 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 *--------------------------------------------------------------------------------------*/

package 
{
    
    
    import com.warmforestflash.ui.FullScreenScrollBar;
    import flash.events.ContextMenuEvent;
    import flash.events.TimerEvent;
    import flash.text.TextField;
    import flash.ui.ContextMenu;
    import flash.ui.ContextMenuItem;
    import flash.utils.Timer;
    import org.joelTong.dingle.gui.controllers.ProgressBar;
    import org.libspark.ui.SWFWheel;
    import flash.display.StageQuality;
    import flash.net.*;
    
    import flash.display.Sprite;
    import org.joelTong.dingle.core.containers.MenuContainer;
    import org.joelTong.dingle.gui.buttons.MenuItem;
    import org.joelTong.dingle.gui.buttons.NativeButton;
    import org.joelTong.dingle.core.*;
    
    import org.joelTong.dingX.common.lazy.SimpleSound;
    import org.joelTong.dingX.common.palette.ColorPattern;
    import org.joelTong.dingX.common.palette.GradientColorPattern;
    import org.joelTong.dingX.common.palette.MinMaxColor32;    
    import org.joelTong.dingX.twoD.initializers.*;
    import org.joelTong.dingX.twoD.visualizations.*;
    
    import org.joelTong.dingle.Config;
    
    import flash.display.StageScaleMode;
    import flash.display.StageAlign;
    
    
    /**
     * joeltong.org
     * @author JOELTONG
     * joel [dot] tong [at] gmail [dot] com
     */
    public class Main extends Sprite {
        
        public var _scrollbar:FullScreenScrollBar;
        
        public function Main():void {
            
            trace("#" + Config.MENU_ITEM_COLOR.toString(16));

            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            Config.WIDTH = stage.stageWidth;
            Config.HEIGHT = stage.stageHeight;
            
            Config.PROGRESS_BAR_WIDTH = Config.WIDTH - Config.PROGRESS_BAR_PADDING * 2;
            
            var initTimer:Timer = new Timer(1, 1);
            initTimer.addEventListener(TimerEvent.TIMER_COMPLETE, init);
            initTimer.start();
            
        }
        
        private function init(e:TimerEvent):void {
            
            buildMenu();
            
            SWFWheel.initialize(stage);
            stage.quality = StageQuality.MEDIUM;
            
            //draw rect to make default bg
            var bg:Sprite = new Sprite();
            bg.graphics.beginFill(Config.MENU_ITEM_COLOR);
            bg.graphics.drawRect(0, 0, Config.WIDTH, Config.HEIGHT);
            addChild(bg);
            
            var menu:MenuContainer = new MenuContainer(stage.stageWidth - 15,0);
            this.addChild(menu);
            menu.x = 0;
            menu.y = stage.stageHeight / 2;
            trace(menu.x);
            
            var cover:Sprite = new Sprite();
            cover.graphics.beginFill(0x000000);
            cover.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight / 2);
            this.addChild(cover);
            
            if (Config.DINGX_VISUALIZATION_TYPE == 0) {
                var compoundVisualizer:CompoundVisual2D = new CompoundVisual2D();                                
                var initializer:InitializerTwoD = new InitializerTwoD(stage.stageWidth, stage.stageHeight / 2);
                var patternG:GradientColorPattern = new GradientColorPattern(Config.VISUAL_0_COLOR_MIN,
                                                                                Config.VISUAL_0_COLOR_MAX,
                                                                                Config.VISUAL_0_COLOR_NO_OF_CYCLES);
                    
                compoundVisualizer.addVisualizer(new Type5(stage.stageWidth + 200, 
                                                            stage.stageHeight, 
                                                            Config.VISUAL_0_PARTICLES_MIN, 
                                                            Config.VISUAL_0_PARTICLES_MAX,
                                                            Config.VISUAL_0_OPTIMAL_FPS, 
                                                            Config.VISUAL_0_PARTICLES_LIFETIME, 
                                                            Config.VISUAL_0_PARTICLES_GRAVITY, 
                                                            Config.VISUAL_0_TIMER_UPDATE,
                                                            Config.VISUAL_0_AMPLITUDE,
                                                            Config.VISUAL_0_PERFORM_FFT,
                                                            Config.VISUAL_0_PARTICLES_BLUR_X,
                                                            Config.VISUAL_0_PARTICLES_BLUR_Y,
                                                            Config.VISUAL_0_PARTICLES_RADIUS,
                                                            patternG));
                compoundVisualizer.addVisualizer(new BasicSpectrumLine(stage.stageWidth + 200, 
                                                                        stage.stageHeight, 
                                                                        Config.VISUAL_0_LINE_THICKNESS,
                                                                        Config.VISUAL_0_LINE_FFT, 
                                                                        Config.VISUAL_0_LINE_AMPLITUDE,
                                                                        Config.VISUAL_0_LINE_TIMER_UPDATE,
                                                                        Config.VISUAL_0_LINE_COLOR, 
                                                                        Config.VISUAL_0_LINE_ALPHA));
                
                var rotateContainer:RotatingContainer = new RotatingContainer(Config.VISUAL_0_ROTATING_SPEED);
                rotateContainer.addVisualizer(compoundVisualizer);
                rotateContainer.x = stage.stageWidth / 2;
                rotateContainer.y = stage.stageHeight / 4;
                rotateContainer.start();
                
                initializer.addVisualizer(rotateContainer);
                
                addChild(initializer);
            }
            
            else if (Config.DINGX_VISUALIZATION_TYPE == 1) {
                var initializer:InitializerTwoD = new InitializerTwoD(stage.stageWidth, stage.stageHeight / 2);
                var pattern:GradientColorPattern = new GradientColorPattern(Config.VISUAL_1_COLOR_MIN,
                                                                                Config.VISUAL_1_COLOR_MAX,
                                                                                Config.VISUAL_1_COLOR_NO_OF_CYCLES);
                                                                                
                initializer.addVisualizer(new Type3(stage.stageWidth, 
                                                    stage.stageHeight / 2,                                                    
                                                    Config.VISUAL_1_CHANNELS_NO,
                                                    Config.VISUAL_1_CHANNELS_BAR_H,
                                                    Config.VISUAL_1_CHANNELS_PARTICLES,
                                                    Config.VISUAL_1_CHANNELS_LIFETIME,
                                                    Config.VISUAL_1_CHANNELS_THRESHOLD,
                                                    Config.VISUAL_1_CHANNELS_GRAVITY,
                                                    Config.VISUAL_1_CHANNELS_EXPLOSION_EXPONENT,
                                                    Config.VISUAL_1_CHANNELS_FOUNTAIN_FORCE,
                                                    Config.VISUAL_1_CHANNELS_UPDATE_TIME,
                                                    pattern));
                                                    
                addChild(initializer);

            }
            
            else if (Config.DINGX_VISUALIZATION_TYPE == 2) {
                                            
                var initializer:InitializerTwoD = new InitializerTwoD(stage.stageWidth, stage.stageHeight / 2);
                var patternG:GradientColorPattern = new GradientColorPattern(Config.VISUAL_2_COLOR_MIN,
                                                                                Config.VISUAL_2_COLOR_MAX,
                                                                                Config.VISUAL_2_COLOR_NO_OF_CYCLES);
                var type1:Type1 = new Type1(stage.stageWidth, 
                                            stage.stageHeight / 2,
                                            Config.VISUAL_2_CHANNELS_NO,
                                            Config.VISUAL_2_CHANNELS_PARTICLES,
                                            Config.VISUAL_2_CHANNELS_EXPLOSION,
                                            Config.VISUAL_2_CHANNELS_THRESHOLD,
                                            Config.VISUAL_2_PARTICLE_RADIUS,
                                            Config.VISUAL_2_PARTICLE_BLUR,
                                            Config.VISUAL_2_PARTICLE_LIFETIME,
                                            patternG);
                initializer.addVisualizer(type1);
                this.addChild(initializer);
                
            }
            
            
            _scrollbar = new FullScreenScrollBar(MenuManager.getInstance(), 
                                                Config.SCROLLBAR_TRACK_COLOR,
                                                Config.SCROLLBAR_GRABBER_COLOR,
                                                Config.SCROLLBAR_GRABBER_PRESS_COLOR,
                                                Config.SCROLLBAR_GRIP_COLOR,
                                                Config.SCROLLBAR_TRACK_THICKNESS,
                                                Config.SCROLLBAR_GRABBER_THICKNESS,
                                                Config.SCROLLBAR_EASE_AMOUNT,
                                                Config.SCROLLBAR_SHINY);

            trace("HT: " + menu.height);
            _scrollbar.y = stage.stageHeight / 2;
            addChild(_scrollbar);
            
            var timer:Timer = new Timer(500, 1);
            timer.addEventListener(TimerEvent.TIMER, onUpdate);
            timer.start();
            
            var rect:Sprite = new Sprite();
            rect.graphics.lineStyle(Config.OUTLINE_THICKNESS, Config.OUTLINE_COLOR);
            rect.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            addChild(rect);
            
            SoundManager.getInstance();
            SoundManager.makeGUI();
            this.addChild(SoundManager.getInstance());
            
            
            
            
            
        }
        
        private function onUpdate(e:TimerEvent):void 
        {
            _scrollbar.adjustSize();

        }
        
        private function buildMenu():void {
            var menu:ContextMenu = new ContextMenu();
            menu.hideBuiltInItems();
            
            var menu1:ContextMenuItem = new ContextMenuItem("Dingle Player Ver. " + Config.DINGLE_VERSION);
            var menu2:ContextMenuItem = new ContextMenuItem("joeltong.org");
            
            menu2.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT, goMyBlog);
            
            menu.customItems.push(menu1);
            menu.customItems.push(menu2);
            this.contextMenu = menu;
        }
        
        private function goMyBlog(e:ContextMenuEvent):void {
            navigateToURL(new URLRequest("http://www.joeltong.org/blog/"), "_this");
        }
        
    }
    
}