/**
 * Copyright tjoen ( http://wonderfl.net/user/tjoen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/p6RW
 */

// forked from shigensur's flash on 2011-5-22
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.media.Camera;
    import flash.media.Video;
    
    import flash.geom.Rectangle;
    
    [SWF(backgroundColor=0xFFFF00, frameRate=15)] // フレームレートを下げておく
    public class WebCamTest3 extends Sprite
    {
        public function WebCamTest3()
        {
            var camera:Camera = Camera.getCamera();
            
            var video:Video = new Video(camera.width, camera.height);
            video.attachCamera(camera);
            
            var bitmapData:BitmapData = new BitmapData(
                camera.width, camera.height);
            
            
            addChild(new Bitmap(bitmapData));
            
            addEventListener(Event.ENTER_FRAME, function(e:Event):void {
                bitmapData.draw(video);
                var line:int = 0;
                for (var x:int = 0; x < bitmapData.width; x++) {
                    for (var y:int = 0; y < bitmapData.height; y++) {
                        var p:uint = bitmapData.getPixel(x, y);
                        
                        var r:uint = p >>16 & 0xFF;
                        var g:uint = p >>8 & 0xFF;
                        var b:uint = p & 0xFF;
                        
                        if (r>192 && g<96 && b<96 ) {
                            bitmapData.setPixel(x, y, 0xFFFFFF);
                            line = x;
                        }
                    }
                }
                
                bitmapData.fillRect(new Rectangle(0, 0, bitmapData.width, 20), 0xFF000000)
                bitmapData.fillRect(new Rectangle(0, 0, line, 4), 0xFF00FF00)
            });
        }
    }
}
