/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/p69Q
 */

// 実行を開始した後の5秒間の最大値と最小値から閾値とヒステリシスを
// 決めるサンプルです
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.utils.Timer;

    import funnel.*;

    [SWF(backgroundColor="0x808080")]

    public class Calibration extends Sprite {
        // Gainer
        private var gainer:Gainer;

        // 入力波形を表示するためのシグナルスコープ
        private var signalScope:SignalScope;

        // 光センサを接続したピン
        private var sensorPin:Pin;

        // 一定時間のキャリブレーションを行うためのタイマ
        private var timer:Timer;

        // 状態やキャリブレーション結果を表示するためのテキストフィールド
        private var textField:TextField;

        public function Calibration() {
            // Gainerのインスタンスを生成し、sensorPinにアナログ入力0をセット
            gainer = new Gainer();
            sensorPin = gainer.analogInput(0);

            // シグナルスコープを生成してセット
            signalScope = new SignalScope(10, 10, 200, "Brightness");
            this.addChild(signalScope);

            // テキストフィールドを生成してセット
            textField = new TextField();
            textField.x = 15;
            textField.y = 140;
            this.addChild(textField);

            // キャリブレーション区間を決めるためのタイマを生成
            // 5000ms後にonTimerCompleteが呼ばれるようにセット
            timer = new Timer(5000, 1);
            timer.addEventListener(TimerEvent.TIMER_COMPLETE, onTimerComplete);

            // テキストフィールドにキャリブレーション中であることを表示してタイマをスタート
            textField.text = "Calibrating...";
            textField.autoSize = TextFieldAutoSize.LEFT;
            timer.start();

            // ENTER_FRAMEイベントに対するイベントリスナをセット
            this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }

        // タイマが完了したら以下を実行
        private function onTimerComplete(e:TimerEvent):void {
            // タイマを停止してイベントリスナを削除
            timer.stop();
            timer.removeEventListener(TimerEvent.TIMER_COMPLETE, onTimerComplete);

            // センサの最大値と最小値から閾値とヒステリシスを求める
            var threshold:Number = (sensorPin.maximum - sensorPin.minimum) / 2 + sensorPin.minimum;
            var hysteresis:Number = (sensorPin.maximum - threshold) / 10;
            textField.text = "threshold: " + threshold.toFixed(3) + ", hysteresis: " + hysteresis.toFixed(3);

            // センサに求めた値を引数としたSetPointフィルタをセット
            sensorPin.addFilter(new SetPoint([threshold, hysteresis]));
        }

        // マイフレームごとに以下を実行
        private function onEnterFrame(e:Event):void {
            // シグナルスコープの表示を更新
            signalScope.update(sensorPin);
        }
    }
}